(function () {
	'use strict';

	var cssTaxZoneClass = function (options) {
		this.init(options);
	};

	cssTaxZoneClass.VERSION = '1.0.2';
	cssTaxZoneClass.DEFAULTS = {
		showDebug : true
	};

	cssTaxZoneClass.prototype = {
		constructor: cssTaxZoneClass,
		init: function (options) {
			this.options = $.extend({}, cssTaxZoneClass.DEFAULTS, options);
			var that = this;
			that.initPlugin();
		},
		register: function(options) {
			var that=this;
			this.debug("ich starte cssTaxZoneClass.VERSION " +  this.__proto__.constructor.VERSION);
		},

		debug: function(s) {
			if(this.options.showDebug) {
				console.log(s);
			}
		},

		_set: function(key,value) {
			this.options.key = value;
		},


		initPlugin: function() {
			var that=this;
			$(document).on("click" , "#css-modalTaxZone a.css-link-steuerzone", function(e) {
				that.debug(e);
				e.preventDefault();
				that.post_data($(this).data("link") + '/io.php','io=css_vatSelect&taxZone=' + $(this).data('tax-zone') + '&taxCountry=' + $(this).data('tax-country'));
			});


			$(document).on("click" , ".css-tax-link", function(e) {
				e.preventDefault();
				that.post_data($(this).data("link") + '/io.php','io=css_vatSelect&setTax=true');
			});

			$(document).on("click" , "#css-modalTaxZone .css-zone-back", function(e) {
				e.preventDefault();
				that.post_data($(this).data("link") + '/io.php','io=css_vatSelect&showTaxZone=true');
			});

			$(document).on("click" , "#css-modalTaxZone .css-tax-back", function(e) {
				e.preventDefault();
				that.post_data($(this).data("link") + '/io.php','io=css_vatSelect&backbutton=true&taxZone=' + $(this).data('tax-zone'));
			});

			$(document).on('click', '.css-alphabet a', function(e) {
				e.preventDefault();
				$(".css-country").slideUp(function() {
				});
				$("." + $(this).attr('href')).slideDown();
			});
		},

		post_data: function (url, data) {
			var that = this;
			jQuery.ajax({
				type: 'POST',
				url: url,
				data: data,
				showNoSuggestionNotice: true,
				dataType: 'json',
				beforeSend: function(jqXHR) {
					jqXHR.overrideMimeType('text/json;charset=iso-8859-1');
				},
				success: function(data,responseText,jqXHR) {
					if( jqXHR.status == 204 ) {
						that.debug('sorry, here is nothing to do for me. (Token problem?)')
						return false;
					}
					if( jqXHR.status == 404 ) {
						that.debug('sorry, here is nothing to show you.')
						return false;
					}
					if( jqXHR.status == 403 ) {
						that.debug('sorry, this is no place for you.')
						return false;
					}
					//debug(data);
					if( data.script )	{
						eval(data.script);
					}
				},
				error: function() {
					that.debug('something is wrong....anything buggy?');
				},
				complete: function() {
				}
			});
		},
	};

	$.cssTaxZone = function(options) {
		$.cssTaxZone = new cssTaxZoneClass(options);
		$.cssTaxZone.register();
		return $.cssTaxZone;
	};

})(jQuery);

jQuery(document).ready(function() {
	$.cssTaxZone({
		showDebug:false
	});
});

