{if !empty($cHinweis)}<div class="alert alert-success">{$cHinweis}</div>{/if}
{if !empty($cError)}<div class="alert alert-danger">{$cError}</div>{/if}

<form method="post"  action="{$cssPlugin->getPluginLink()}" data-plugin="{$oPlugin->getPluginID()}" data-io="{$cssPlugin->getAdminIOLink()}" data-session="{$smarty.session.jtl_token}">
    {$jtl_token}
    <input type="hidden" name="cssAdminConfigAction" value="saveConfig" />

    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="plugin">{__('Plugin Konfiguration')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Funktionsweise des Plugins.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>
            <div class="css-tooltip">
                Über dieses Symbol erhalten Sie die Erklärung der jeweiligen Funktionen und Einstellungen
                <div class="css-close"><i class="fa fa-close"></i></div>
            </div>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Das Plugin ist')}</span>
            </div>
            <select id="pluginActive" name="pluginActive" class="form-control">
                <Option {if $pluginConfig->pluginActive=='Y'} selected {/if} value="Y">{__('Aktiviert')}</Option>
                <Option {if $pluginConfig->pluginActive=='N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
            </select>
            <div class="input-group-append">
                <span class="input-group-text" data-section="active">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen Sie fest ob das Plugin aktiv ist.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <!-- ab hier kommen die individuellen Einstellungen -->
    </fieldset>
    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="maxmind">{__('MaxMind (GeoLite2) Konfiguration')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Funktionsweise des Plugins.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Account/User ID MaxMind')}</span>
            </div>
            <input type="text" name="maxMindUserAccount" class="form-control" value="{$pluginConfig->maxMindUserAccount}" placeholder="{__('User ID von MaxMind')}">
            <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Bitte tragen Sie Ihren Account von MaxMind ein.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Lizenskey bei MaxMind')}</span>
            </div>
            <input type="text" name="maxMindUserKey" id="maxMindUserKey" class="form-control" value="{$pluginConfig->maxMindUserKey}" placeholder="{__('Token von MaxMind')}">
            <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Bitte tragen Sie Ihren Lizenzkey von MaxMind ein.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>
        {if !empty($pluginConfig->maxMindUserKey)}
            {if $autoImport===false}
                <div class="alert alert-warning" style="margin-top:15px; padding:10px;">
                    <p>{__('Ihre Serverkonfiguration erlaubt es nicht, Shellbefehle auszuführen, daher ist ein automatischer Import der MaxMind Datenbank nicht möglich. Bitte beachten Sie die Anweisungen in der Dokumentation.')}</p>
                </div>
            {else}
                {if $isWriteable===false}
                    <div class="alert alert-warning" style="margin-top:15px; padding:10px;">
                        <p>{__('Das Verzeichnis {$css_dataPath} ist nicht beschreibbar, bitte vergeben Sie diesem Verzeichnis Schreibrechte.')}</p>
                    </div>
                {else}
                    <div id="geoImport-button" style="position:relative;">
                        <button type="button" class="btn btn-default geoIPImport">GeoLite2 Import</button>
                    </div>
                    <div class="alert alert-warning " style="margin-top:15px;">
                      <p>
                        Der früher verwendete cronjob ist nicht mehr erforderlich.<br>
                        Sie haben die Möglichkeit, über die <a href="{\JTL\Shop::getUrl()}\admin/cron"><u>Cron Verwaltung</u></a> den Cronjob <strong>GEO IP - MaxMind Aktualisierung</strong> zu aktivieren.<br>
                        Es reicht aus, wenn Sie als Frequenz 168 Stunden auswählen.
                      </p>
                    </div>
                {/if}

            {/if}
        {/if}

    </fieldset>








      <fieldset class="border p-2 form-group">
        <legend class="w-auto">{__('Template Konfiguration')}</legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Template Framework')}</span>
            </div>
            <select id="framework" name="framework" class="form-control">
                <Option {if $pluginConfig->framework=='B3'} selected {/if} value="B3">{__('Bootstrap 3 (z.B. EVO)')}</Option>
                <Option {if $pluginConfig->framework=='B4'} selected {/if} value="B4">{__('Bootstrap 4 (z.B. NOVA)')}</Option>
                {if isset($bHasCustom)}
                    <Option {if $pluginConfig->framework=='custom'} selected {/if}
                            value="custom">{__('Custom (Ihre eigene updatesichere Pluginmodifikation)')}</Option>
                {/if}
            </select>
            <div class="input-group-append" data-section="framework">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier geben Sie an, welches Framework Ihr Template nutzt, Wenn Sie es nicht wissen, fragen Sie bitte den Hersteller des Templates.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>
        <div class="input-group mb-3" style="margin-top:-17px;">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Default Konfiguration Templates')}</span>
            </div>
            <button data-template="nova" class="form-control btn btn-default" type="button">Nova / Salepix</button>
            <button data-template="admorris" class="form-control btn btn-default" type="button">admorris</button>
            <button data-template="snackys" class="form-control btn btn-default" type="button">Snackys</button>
            <button data-template="salepix" class="form-control btn btn-default" type="button">Salepix</button>
            <button data-template="easytemplate" class="form-control btn btn-default" type="button">easytemplate</button>
            <div class="input-group-append" data-section="defaultselector">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selectoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <fieldset class=" p-2 form-group" style="border:1px solid #5cbcf6; margin:10px 35px; ">
            <legend class="w-auto" data-section="selector_artikel">
                {__('Selektor für die Anzeige in der Artikel Detailseite')}
                <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                      data-original-title="{__('Selektor für die Anzeige in der Artikel Detailseite')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>

            </legend>

            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Selector')}</span>
                </div>
                <input type="text" name="selector_artikel" class="form-control" value="{$pluginConfig->selector_artikel}"
                       placeholder="{__('Bitte den Selector eintragen')}">
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen den Selector fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Einfügemethode')}</span>
                </div>
                <select id="selector_artikel_position" name="selector_artikel_position" class="form-control">
                    <Option {if $pluginConfig->selector_artikel_position=='off'} selected {/if} value="off">{__('Deaktiviert')}</Option>
                    <Option {if $pluginConfig->selector_artikel_position=='prepend'} selected {/if}
                            value="prepend">{__('Am Anfang des Elements')}</Option>
                    <Option {if $pluginConfig->selector_artikel_position=='append'} selected {/if}
                            value="append">{__('Am Ende des Elements')}</Option>
                    <Option {if $pluginConfig->selector_artikel_position=='before'} selected {/if} value="before">{__('vor dem Element')}</Option>
                    <Option {if $pluginConfig->selector_artikel_position=='after'} selected {/if} value="after">{__('Nach dem Element')}</Option>
                    <Option {if $pluginConfig->selector_artikel_position=='html'} selected {/if}
                            value="html">{__('Inhalt des Elements ersetzen')}</Option>
                </select>
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Einfügemethode fest oder deaktivieren diese Option.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
        </fieldset>

        <fieldset class=" p-2 form-group" style="border:1px solid #5cbcf6; margin:10px 35px; ">
            <legend class="w-auto" data-section="selector">
                {__('Selektor für die Anzeige der Auswahl auf jeder Seite')}
                <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                      data-original-title="{__('Selektor für die Anzeige der Auswahl auf jeder Seite')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>

            </legend>

            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Selector')}</span>
                </div>
                <input type="text" name="selector" class="form-control" value="{$pluginConfig->selector}"
                       placeholder="{__('Bitte den Selector eintragen')}">
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen den Selector fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Einfügemethode')}</span>
                </div>
                <select id="selector_position" name="selector_position" class="form-control">
                    <Option {if $pluginConfig->selector_position=='off'} selected {/if} value="off">{__('Deaktiviert')}</Option>
                    <Option {if $pluginConfig->selector_position=='prepend'} selected {/if}
                            value="prepend">{__('Am Anfang des Elements')}</Option>
                    <Option {if $pluginConfig->selector_position=='append'} selected {/if}
                            value="append">{__('Am Ende des Elements')}</Option>
                    <Option {if $pluginConfig->selector_position=='before'} selected {/if} value="before">{__('vor dem Element')}</Option>
                    <Option {if $pluginConfig->selector_position=='after'} selected {/if} value="after">{__('Nach dem Element')}</Option>
                    <Option {if $pluginConfig->selector_position=='html'} selected {/if}
                            value="html">{__('Inhalt des Elements ersetzen')}</Option>
                </select>
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Einfügemethode fest oder deaktivieren diese Option.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
        </fieldset>


    </fieldset>





















    <fieldset class="border p-2 form-group">
        <legend class="w-auto">{__('Konfiguration')}</legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Zuweisung des Steuerlandes')}</span>
            </div>
            <select id="showModalTax" name="showModalTax" class="form-control" >
                <Option {if $pluginConfig->showModalTax== 'n'} selected {/if} value="N">{__('Keine automatische Zuweisung (kein automatisches Fenster / Auswahl nur per Link)')}</Option>
                <Option {if $pluginConfig->showModalTax== 'M'} selected {/if} value="M">{__('Modales Fenster')}</Option>
                <Option {if $pluginConfig->showModalTax== 'G'} selected {/if} value="G">{__('Automatische Erkennung durch GeoLite2')}</Option>
                <Option {if $pluginConfig->showModalTax== 'GM'} selected {/if} value="GM">{__('Modales Fenster bei Nichterkennung durch GeoLite2')}</Option>
            </select>
            <div class="input-group-append" data-section="modalTax">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Aktivieren oder deaktivieren Sie die Lieferland Abfrage.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Nur belieferbare Länder anzeigen')}</span>
            </div>
            <select id="showAllowedCountrys" name="showAllowedCountrys" class="form-control" >
                <Option {if $pluginConfig->showAllowedCountrys== 'N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
                <Option {if $pluginConfig->showAllowedCountrys== 'Y'} selected {/if} value="Y">{__('Aktiviert')}</Option>
            </select>
            <div class="input-group-append"  data-section="countrys">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('bei Aktivierung werden nur noch belieferbare Länder angezeigt.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Alphabetische Vorauswahl ab X Einträgen')}</span>
            </div>
            <select id="maxCountrys" name="maxCountrys" class="form-control" >
                {for $foo=10 to 50}
                    <Option {if $pluginConfig->maxCountrys == $foo} selected {/if} value="{$foo}">{$foo}</Option>
                {/for}
            </select>
            <div class="input-group-append">
                <span class="input-group-text" data-section="choice">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Maximale Anzahl der Länder bevor eine Alphabetische Vorauswahl zu sehen ist.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Anzeige der Steuerinformationen')}</span>
            </div>
            <select id="showTaxInformation" name="showTaxInformation" class="form-control" >
                <Option {if $pluginConfig->showTaxInformation== 'N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
                <Option {if $pluginConfig->showTaxInformation== 'Y'} selected {/if} value="Y">{__('Aktiviert')}</Option>
            </select>
            <div class="input-group-append"  data-section="tax">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Aktivieren oder deaktivieren Sie die Steuerinformation.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend" >
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Bot Erkennung')}</span>
            </div>
            <select id="botDetection" name="botDetection" class="form-control" >
                <Option {if $pluginConfig->botDetection== 'N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
                <Option {if $pluginConfig->botDetection== 'Y'} selected {/if} value="Y">{__('Aktiviert (empfohlen)')}</Option>
            </select>
            <div class="input-group-append">
                <span class="input-group-text" data-section="botDetection">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Aktivieren oder deaktivieren Sie die Bot Erkennung, dies verhindert die automatisierte Umstellung und ist insbesondere für Googleshopping relevant.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Feed Parameter für Preislisten')}</span>
            </div>
            <input type="text" name="feedParameter" class="form-control" value="{$pluginConfig->feedParameter}" placeholder="{__('country')}">
            <div class="input-group-append">
                <span class="input-group-text" data-section="feed">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Sie können Ihren Feeds wie Googleshopping einen Parameter hinzufügen damit die entsprechende Steuer für das zum Feed zugehörigem Land angezeigt wird.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

    </fieldset>
    <fieldset class="border p-2 form-group">
        <legend class="w-auto"  data-section="steuerzonen">
            {__('Vorhandene Steuerzonen')}
                      <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Funktionsweise des Plugins.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>

        </legend>

        <div class="alert alert-info">
            <p>{__('Bezeichnung der Steuerzonen in den jeweiligen Shop Sprachen Sie k&ouml;nnen die Zonen in der Reihenfolge verschieben')}</p>
        </div>
        <ul id="sortable" style="padding-left:0; list-style-type: none; list-style-position: outside;padding:0 0;">
            {foreach from=$aTaxZones item=oTaxZone name='taxCountrys'}
                {$imgFlag=''}
                {if !empty($pluginConfig->TaxZoneIcon[$oTaxZone->kSteuerzone])}
                    {$imgFlag =$oCssPlugin->getPluginURL()|cat:'flags/4x3/'|cat:$pluginConfig->TaxZoneIcon[$oTaxZone->kSteuerzone] }
                    {else}
                    {if !empty($oTaxZone->cISO)}
                        {$tmpflag = $oCssVatSelectPlugin->getPaths()->getFrontendPath()|replace:"/frontend/":"/"|cat:'flags/4x3/'|cat:strtolower($oTaxZone->cISO)|cat:'.svg'}
                        {if file_exists($tmpflag)}
                            {$emptyInputFlag =strtolower($oTaxZone->cISO)}
                            {$imgFlag = $oCssPlugin->getPluginURL()|cat:'flags/4x3/'|cat:strtolower($oTaxZone->cISO)|cat:'.svg'}
                        {else}
                        {/if}
                        {__('noch keine Flagge ausgew&auml;hlt')}
                    {/if}
                {/if}


            <li class="ui-state-default" style=" margin-top:10px; padding:0 10px;">
                <div class="panel-heading">
                    <h3 class="panel-title" style="height:auto; position:relative; padding:5px;" >{$oTaxZone->cName} <i style="position:absolute; right:15px; top:10px; color:darkred" class="fa fa-bars" aria-hidden="true""></i></h3>
                </div>

                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">
                            <input type="hidden"
                                   value="{if !empty($pluginConfig->TaxZoneIcon[$oTaxZone->kSteuerzone])}{$pluginConfig->TaxZoneIcon[$oTaxZone->kSteuerzone]}{else}{if !empty($emptyInputFlag)}{$emptyInputFlag}.svg{/if}{/if}" name="TaxZoneIcon[{$oTaxZone->kSteuerzone}]" id="TaxZoneIcon{$oTaxZone->kSteuerzone}" >
                            <span class="img">
                                {if !empty($imgFlag)}
                                    <img src="{$imgFlag}"  alt="" width='32px'>
                                {else}
                                    noch keine Flagge ausgewählt
                                {/if}
                            </span>
                        </span>
                    </div>
                    <button id="TaxZoneButton{$oTaxZone->kSteuerzone}" type="button" class="css-flag-button form-control btn btn-default btn-lg form-control">{__('Flagge ausw&auml;hlen')}</button>
                    <select id="TaxZoneShow{$oTaxZone->kSteuerzone}" name="TaxZoneShow[{$oTaxZone->kSteuerzone}]" class="form-control">
                        <Option {if !empty($pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]) && $pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]=='Y'} selected {/if} value="Y">{__('anzeigen')}</Option>
                        <Option {if !empty($pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]) && $pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]=='N'} selected {/if} value="N">{__('nicht anzeigen')}</Option>
                    </select>
                    <div class="input-group-append">
                        <span class="input-group-text">
                            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                                  data-original-title="{__('Bitte w&auml;hlen Sie eine passende Flagge für das Land aus.')}">
                                <span class="fas fa-info-circle fa-fw"></span>
                            </span>
                       </span>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend" >
                        <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Umschalten der W&auml;hrung')}</span>
                    </div>
                    <select id="TaxZoneCurrency_{$oTaxZone->kSteuerzone}"
                            name="TaxZoneCurrency[{$oTaxZone->kSteuerzone}]" class="form-control">

                        <Option value="">{__('Keine Umschaltung')}</Option>
                        {foreach from=$aTaxCurrency item=tg }
                            <Option {if !empty($pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]) && $pluginConfig->TaxZoneCurrency[$oTaxZone->kSteuerzone] == $tg->kWaehrung } selected {/if} value="{$tg->kWaehrung}">{$tg->cName}</Option>
                        {/foreach}
                    </select>
                    <div class="input-group-append">
                        <span class="input-group-text">
                            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                                  data-original-title="{__('W&auml;hlen Sie bitte, ob die W&auml;hrung abh&auml;ngig von der Steuerzone ge&auml;ndert werden soll.')}">
                                <span class="fas fa-info-circle fa-fw"></span>
                            </span>
                       </span>
                    </div>
                </div>

                <div class="input-group mb-3">
                    <div class="input-group-prepend" >
                        <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Umschalten der Kundengruppe')}</span>
                    </div>

                    <div class="input-group-append multiconfig" >
                    <select id="TaxZoneGroup{$oTaxZone->kSteuerzone}"
                            name="TaxZoneGroup[{$oTaxZone->kSteuerzone}]" class="form-control">

                        <Option value="">{__('Keine Umschaltung')}</Option>
                        {foreach from=$aTaxGroups item=tg }
                            <Option {if !empty($pluginConfig->TaxZoneShow[$oTaxZone->kSteuerzone]) && $pluginConfig->TaxZoneGroup[$oTaxZone->kSteuerzone] == $tg->kKundengruppe } selected {/if} value="{$tg->kKundengruppe}">{$tg->cName}</Option>
                        {/foreach}
                    </select>
                    </div>
{if $oCssVatSelect->compareShopVersion("5.2")}
                     <div class="input-group-append multiconfig">
                        <select id="fixGroup{$oTaxZone->kSteuerzone}"
                                name="fixGroup[{$oTaxZone->kSteuerzone}]" class="form-control">
                            <Option {if !empty($pluginConfig->fixGroup[$oTaxZone->kSteuerzone]) && $pluginConfig->fixGroup[$oTaxZone->kSteuerzone] == 'N'} selected='selected'{/if} value="N">{__('Kundengruppe von Kunden nicht überschreiben ')}</Option>
                            <Option {if !empty($pluginConfig->fixGroup[$oTaxZone->kSteuerzone]) && $pluginConfig->fixGroup[$oTaxZone->kSteuerzone] == 'Y'} selected='selected'{/if} value="Y">{__('Kundengruppe von Kunden überschreiben dauerhaft speichern')}</Option>
                            <Option {if !empty($pluginConfig->fixGroup[$oTaxZone->kSteuerzone]) && $pluginConfig->fixGroup[$oTaxZone->kSteuerzone] == 'TY'} selected='selected'{/if} value="TY">{__('Kundengruppe von Kunden temporär überschreiben')}</Option>
                        </select>
                    </div>
{/if}
                    <div class="input-group-append">
                        <span class="input-group-text">
                            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                                  data-original-title="{__('Zur Gruppe Kunde zählen alle User, die angemeldet sind oder Ihre Daten im Checkoutprozess eingegeben haben.')}">
                                <span class="fas fa-info-circle fa-fw"></span>
                            </span>
                       </span>
                    </div>
                </div>
                {foreach from=$aSprachen item=oSprache name='sprachen'}
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{$oSprache->cNameDeutsch}</span>
                        </div>
                        <input name="TaxZoneLanguage[{$oTaxZone->kSteuerzone}][{$oSprache->kSprache}]" id="TaxZoneLanguage{$oTaxZone->kSteuerzone}_{$oSprache->kSprache}"
                               placeholder=""  type="text" class="form-control"
                               value="{if !empty($pluginConfig->TaxZoneLanguage[$oTaxZone->kSteuerzone][$oSprache->kSprache])}{$pluginConfig->TaxZoneLanguage[$oTaxZone->kSteuerzone][$oSprache->kSprache]}{else}{$oTaxZone->cName}{/if}">
                        <div class="input-group-append">
                            <span class="input-group-text">
                                <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                                      data-original-title="{__('Angezeigter Text f&uuml;r die Sprache')} {$oSprache->cNameDeutsch}">
                                    <span class="fas fa-info-circle fa-fw"></span>
                                </span>
                           </span>
                        </div>
                    </div>

                {/foreach}
            </li>
            {/foreach}
        </ul>
        <script>
            $( function() {
                $( "#sortable" ).sortable();
                $( "#sortable" ).disableSelection();

                $( "#sortable" ).on( "sortstart change start", function( event, ui ) {
                    console.log(event);

                } );
            } );
        </script>
    </fieldset>
    <fieldset class="border p-2 form-group">
        <legend class="w-auto">{__('Sprache Steuerklassen')}</legend>

        <div class="alert alert-info">
            <p>Bezeichnung der Steuerklassen in den jeweiligen Shop Sprachen, lassen Sie das Feld einer Klasse frei, wird dieses nicht angezeigt</p>
        </div>

        {foreach from=$aTaxClasses item=oTaxClass name='taxCClasses'}
            <div class="panel-heading">
                <h3 class="panel-title" style="height:auto;">{$oTaxClass->cName}</h3>
            </div>
            {foreach from=$aSprachen item=oSprache name='sprachen'}
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{$oSprache->cNameDeutsch}</span>
                    </div>
                    <input name="TaxClassLanguage[{$oTaxClass->kSteuerklasse}][{$oSprache->kSprache}]" id="TaxClassLanguage{$oTaxClass->kSteuerklasse}_{$oSprache->kSprache}"
                           placeholder=""  type="text" class="form-control" value="{if empty($pluginConfig->TaxClassLanguage[$oTaxClass->kSteuerklasse]) && empty($pluginConfig->TaxClassLanguage[$oTaxClass->kSteuerklasse][$oSprache->kSprache])}{$oTaxClass->cName}{else}{$pluginConfig->TaxClassLanguage[$oTaxClass->kSteuerklasse][$oSprache->kSprache]}{/if}">
                    <div class="input-group-append">
                        <span class="input-group-text">
                            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                                  data-original-title="{__('Angezeigter Text f&uuml;r die Sprache')} {$oSprache->cNameDeutsch}">
                                <span class="fas fa-info-circle fa-fw"></span>
                            </span>
                       </span>
                    </div>
                </div>
            {/foreach}
        {/foreach}

    </fieldset>
    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="css_js">
            {__('Zusätzliche Styles/ JavaScript')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Nutzung des JS / CSS.')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
        </legend>


        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Styles')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror sass" id="css"
                          name="css">{$pluginConfig->css}</textarea>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('JavaScript')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror JavaScript" id="js"
                          name="js">{$pluginConfig->js}</textarea>
            </div>
        </div>

    </fieldset>

<div class="save-wrapper">
    <div class="ml-auto col-sm-6 col-xl-auto">
        <button name="a" type="submit" value="" class="btn btn-outline-primary btn-block save">
            <i class="fas fa-save"></i>&nbsp;{__('Konfiguration speichern')}
        </button>
    </div>
</div>
</form>

<script>
    jQuery(document).ready(function() {
        $("#css-modalFlags").modal('show');
        $(document).on("click" , "#css-modalFlags a.css-link-flags", function(e) {
            e.preventDefault();
        });

        $(document).on('click', '.css-alphabet a', function(e) {
            e.preventDefault();
            console.log($(this).attr('href'));
            $(".css-flags").slideUp(function() {
                console.log("hallo");
            });
            $("." + $(this).attr('href')).slideDown();
        });

        $(document).on("click", ".css-link-flags" , function() {
            console.log("clicked", $(this).data("element"));
            var group = $("#" + $(this).data("element")).closest(".input-group");

            $(group).find("input").val($(this).data("img"));
            $(group).find(".img").html("<img width='32px' src='{$oCssPlugin->getPluginURL()}/flags/4x3/" +  $(this).data("img") + "' >");
            $("#css-modalFlags").modal("hide");
        });


    });
</script>

<style>

    .css-tax-flex-container {
        display: flex;
        flex-wrap:wrap;
    }

    .css-tax-flex-container > div {
        margin:5px 0;
    }
    .css-country {
        display:none;
    }

    #css-modalFlags .modal-dialog {
        transition: width .05s ease-in-out;
    }

    #css-modalFlags .css-alphabet a {
        display:inline-block;
        text-align:center;
        width:30px;
    }
    #css-modalFlags .css-link-flags {
        padding-left:30px;
        position:relative;
        display:block;
        min-height:20px;
    }
    #css-modalFlags .css-link-flags > img {
    }
</style>

<script>
  $(function () {
    $(document).on("change", "#pluginActive", function () {
      $(this).removeClass("pluginActive-Y pluginActive-N").addClass("pluginActive-" + $(this).val()).blur();
    });
    $("#pluginActive").trigger("change");
  });
</script>
