// Version 2.0

/*!
 * jQuery Cookie Plugin v1.4.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */
(function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD
        define(['jquery'], factory);
    } else if (typeof exports === 'object') {
        // CommonJS
        factory(require('jquery'));
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {

    var pluses = /\+/g;

    function encode(s) {
        return config.raw ? s : encodeURIComponent(s);
    }

    function decode(s) {
        return config.raw ? s : decodeURIComponent(s);
    }

    function stringifyCookieValue(value) {
        return encode(config.json ? JSON.stringify(value) : String(value));
    }

    function parseCookieValue(s) {
        if (s.indexOf('"') === 0) {
            // This is a quoted cookie as according to RFC2068, unescape...
            s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
        }

        try {
            // Replace server-side written pluses with spaces.
            // If we can't decode the cookie, ignore it, it's unusable.
            // If we can't parse the cookie, ignore it, it's unusable.
            s = decodeURIComponent(s.replace(pluses, ' '));
            return config.json ? JSON.parse(s) : s;
        } catch(e) {}
    }

    function read(s, converter) {
        var value = config.raw ? s : parseCookieValue(s);
        return $.isFunction(converter) ? converter(value) : value;
    }

    var config = $.cookie = function (key, value, options) {

        // Write

        if (value !== undefined && !$.isFunction(value)) {
            options = $.extend({}, config.defaults, options);

            if (typeof options.expires === 'number') {
                var days = options.expires, t = options.expires = new Date();
                t.setTime(+t + days * 864e+5);
            }

            return (document.cookie = [
                encode(key), '=', stringifyCookieValue(value),
                options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
                options.path    ? '; path=' + options.path : '',
                options.domain  ? '; domain=' + options.domain : '',
                options.secure  ? '; secure' : ''
            ].join(''));
        }

        // Read

        var result = key ? undefined : {};

        // To prevent the for loop in the first place assign an empty array
        // in case there are no cookies at all. Also prevents odd result when
        // calling $.cookie().
        var cookies = document.cookie ? document.cookie.split('; ') : [];

        for (var i = 0, l = cookies.length; i < l; i++) {
            var parts = cookies[i].split('=');
            var name = decode(parts.shift());
            var cookie = parts.join('=');

            if (key && key === name) {
                // If second argument (value) is a function it's a converter...
                result = read(cookie, value);
                break;
            }

            // Prevent storing a cookie that we couldn't decode.
            if (!key && (cookie = read(cookie)) !== undefined) {
                result[name] = cookie;
            }
        }

        return result;
    };

    config.defaults = {};

    $.removeCookie = function (key, options) {
        if ($.cookie(key) === undefined) {
            return false;
        }

        // Must not alter options, thus extending a fresh object...
        $.cookie(key, '', $.extend({}, options, { expires: -1 }));
        return !$.cookie(key);
    };

}));


var cssHashCode  = function() {
    var hash = 5381, i = this.length;
    while(i)
        hash = (hash * 33) ^ this.charCodeAt(--i);
    return hash >>> 0;
};

jQuery(document).ready(function() {
//  $("html").addClass('theme-dark');
    cssHashCode(document.location.href);
    $('.tabs-nav a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href"); // activated tab
        $.cookie('target', target, {expires: 7});
    });

    if ($.cookie('target') != 'undefined') {
        $(".tabs-nav li.nav-item a[href='" + $.cookie('target') + "']").tab('show');
    }

    $(".content-header").addClass("css-content");


// nur ausf�hren wenn es ein Shop < 5.3 ist
    if(!$(".card-widget .chevronToggle")) {

        $(".css-content ").each(function () {
            $(this).html('<div class="inner">' + $(this).html() + '</div>').append('<div class="text-center css-more-button"><span class="fa fa-angle-double-down"></span></div>');
        });

        $(".content-header").prepend($(".css-content .row").remove());

        $("body").on("click", ".css-more-button", function () {
            $(this).closest(".css-content").addClass("load");
            if ($(this).closest(".css-content").hasClass("in")) {
            } else {
                $("body .css-content.in").not(".load").removeClass("in").find(".inner.in").slideUp(500).removeClass("in");
            }
            $(this).closest(".css-content").removeClass("load");
            $(this).closest(".css-content").find(".inner").slideDown(500, function () {
                if ($(this).closest(".versandoption").length) {
                    $([document.documentElement, document.body]).animate({
                        scrollTop: $(this).closest(".versandoption").offset().top - 100
                    }, 1000);
                }
            });
            $(this).closest(".css-content").find(".inner.in").slideUp(500);
            $(this).closest(".css-content").find(".inner").toggleClass("in");
            $(this).closest(".css-content").toggleClass("in");
        });

    }
});

$(function () {
  $(".css-tooltip").on("click", function (e) {
    $.cookie('cssToolTip', 'close', {expires: 360});
    $(".css-tooltip").animate({opacity: 0}, 1000, function () {
      $(".css-tooltip").remove();
    });
    return false;
  });
  if (typeof $.cookie('cssToolTip') === 'undefined') {
    $(".css-tooltip").animate({opacity: 1}, 2000);
  } else {
    $(".css-tooltip").remove();
  }

});

