<?php declare(strict_types=1);

namespace Plugin\css_vatSelect\Migrations;

use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20230426123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20241016123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		if($this->tableExist($table)) {
			return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
		}
		return false;
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}





	public function up()    {
		if($this->columnExist('css_vatSelectConfig','fixGroup') === false) {
			$this->execute("ALTER TABLE `css_vatSelectConfig` ADD `fixGroup` TEXT NOT NULL");
		}
		if($this->columnExist('css_vatSelectConfig','framework')) {
			$this->execute("ALTER TABLE `css_vatSelectConfig` CHANGE `framework` `framework` CHAR(20)	");
			$this->execute("UPDATE `css_vatSelectConfig` set `framework`='custom' where `framework` ='CU'");
		}
		if($this->columnExist('css_vatSelectConfig','version')) {
	    $this->execute("UPDATE css_vatSelectConfig set `version` = '2.5.0' ");
    }
  }

    /**
     * @inheritdoc
     */
    public function down() {
        if ($this->doDeleteData()) {
        }
    }
}
