<?php declare(strict_types=1);

namespace Plugin\css_vatSelect\Migrations;

use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20210429123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20210429123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */

    public function copyTable($sourceDB,$destinationDB="", $copyTable=true,$deleteSourceDB=false) {
        error_log('starte copy '.$sourceDB);
        $result = $this->getDB()->query("SHOW TABLES LIKE '".$sourceDB."'",2);
        if($copyTable && $result !== null && is_array($result) && count($result)) {
            error_log('DB Vorhanden '.$sourceDB);
            $result = $this->getDB()->query("SELECT * FROM ".$sourceDB." WHERE 1",2);
            foreach($result as $oItem) {
                error_log('schreibe Datensatz nach '.$destinationDB);
                $this->getDB()->insert($destinationDB,$oItem);
            }
        }
        if($deleteSourceDB) {
            $this->execute("DROP TABLE IF EXISTS ".$sourceDB,3);
        }
    }

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		if($this->tableExist($table)) {
			return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
		}
		return false;
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}


    public function up()    {
	    $copyTable = true;

	    if (($obj = $this->tableExist('css_vatSelectConfig')) && $obj->Rows > 0) {
				$copyTable = false;
	    }

		    $this->execute("
              CREATE TABLE IF NOT EXISTS `css_vatSelectConfig` (
                  `version` varchar(255) NOT NULL DEFAULT '2.0.0',
                  `sqlupdate` int(10) NOT NULL DEFAULT '0',
                  `pluginActive` char(1) NOT NULL default 'N',
                  `framework` char(3) NOT NULL default 'B4',
                  `css` text NOT NULL,
                  `js` text NOT NULL,
                  `TaxClassLanguage` text NOT NULL,
                  `TaxZoneIcon` text NOT NULL,
                  `TaxZoneLanguage` text NOT NULL,
                  `showTaxInformation` char(1) NOT NULL DEFAULT 'Y',
                  `showModalTax` char(2) NOT NULL DEFAULT 'Y',
                  `botDetection` char(1) NOT NULL DEFAULT 'Y',
                  `maxMindUserAccount` varchar(255) NOT NULL DEFAULT '',
                  `maxMindUserKey` varchar(255) NOT NULL DEFAULT '',
                  `selector_artikel` varchar(255) NOT NULL DEFAULT '.product-offer .vat_info',
                  `selector_artikel_position` varchar(255) NOT NULL DEFAULT 'append',
                  `selector` varchar(255) NOT NULL DEFAULT '#content',
                  `selector_position` varchar(255) NOT NULL DEFAULT 'off',
                  `showAllowedCountrys` char(1) NOT NULL DEFAULT 'N',
                  `maxCountrys` int(3) NOT NULL DEFAULT '10',
                  `TaxZoneGroup` text NOT NULL,
                  `TaxZoneCurrency` text NOT NULL,
                  `TaxZoneShow` text NOT NULL,
                  `changeGroupAllways` char(1) NOT NULL DEFAULT 'N'
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");

			if($copyTable) {
				$this->copyTable("css_vatSelect_konfig","css_vatSelectConfig",true,false);
			}




	    if (($obj = $this->tableExist('css_vatSelectConfig')) && $obj->Rows > 0) {
		    $this->execute("UPDATE css_vatSelectConfig set `version` = '2.0.0' ");
	    } else {
		    $this->execute(
			    "INSERT INTO `css_vatSelectConfig` (`version`) VALUES ('2.0.0')"
		    );
	    }
    }

    /**
     * @inheritdoc
     */
    public function down() {
        if ($this->doDeleteData()) {
        }
    }
}
