(function () {
    'use strict';

    var cssTransferCodeClass = function (options) {
        this.init(options);
    };

    cssTransferCodeClass.VERSION = '2.0.0';
    cssTransferCodeClass.DEFAULTS = {
        showDebug: true
    };

    cssTransferCodeClass.prototype = {
        constructor: cssTransferCodeClass,
        init: function (options) {
            this.options = $.extend({}, cssTransferCodeClass.DEFAULTS, options);
            var that = this;
            that.initPlugin();
        },
        register: function (options) {
            var that = this;
            this.debug("ich starte cssTransferCodeClass.VERSION " + this.__proto__.constructor.VERSION);
        },

        debug: function (s) {
            if (this.options.showDebug) {
                console.log(s);
            }
        },

        _set: function (key, value) {
            this.options.key = value;
        },


        initPlugin: function () {
            var that = this;
        },

        post_data: function (url, data) {
            var that = this;
            jQuery.ajax({
                type: 'POST',
                url: url,
                data: data,
                showNoSuggestionNotice: true,
                dataType: 'json',
                beforeSend: function (jqXHR) {
                    jqXHR.overrideMimeType('text/json;charset=iso-8859-1');
                },
                success: function (data, responseText, jqXHR) {
                    if (jqXHR.status == 204) {
                        that.debug('sorry, here is nothing to do for me. (Token problem?)')
                        return false;
                    }
                    if (jqXHR.status == 404) {
                        that.debug('sorry, here is nothing to show you.')
                        return false;
                    }
                    if (jqXHR.status == 403) {
                        that.debug('sorry, this is no place for you.')
                        return false;
                    }
                    //debug(data);
                    if (data.script) {
                        eval(data.script);
                    }
                },
                error: function () {
                    that.debug('something is wrong....anything buggy?');
                },
                complete: function () {
                }
            });
        },
    };

    $.cssTransferCode = function (options) {
        $.cssTransferCode = new cssTransferCodeClass(options);
        $.cssTransferCode.register();
        return $.cssTransferCode;
    };

})(jQuery);

jQuery(document).ready(function () {
    $.cssTransferCode({
        showDebug: false
    });
});

