{if !empty($cHinweis)}
    <div class="alert alert-success">{$cHinweis}</div>{/if}
{if !empty($cError)}
    <div class="alert alert-danger">{$cError}</div>{/if}

<form method="post" data-plugin="{$oPlugin->getPluginID()}" data-io="{$cssPlugin->getAdminIOLink()}"
      data-session="{$smarty.session.jtl_token}">
    {$jtl_token}
    <input type="hidden" name="cssAdminConfigAction" value="saveConfig"/>


    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="plugin">{__('Plugin Konfiguration')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Funktionsweise des Plugins.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>
            <div class="css-tooltip">
                Über dieses Symbol erhalten Sie die Erklärung der jeweiligen Funktionen und Einstellungen
                <div class="css-close"><i class="fa fa-close"></i></div>
            </div>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Das Plugin ist')}</span>
            </div>
            <select id="pluginActive" name="pluginActive" class="form-control">
                <Option {if $pluginConfig->pluginActive=='Y'} selected {/if} value="Y">{__('Aktiviert')}</Option>
                <Option {if $pluginConfig->pluginActive=='N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
            </select>
            <div class="input-group-append" data-section="active">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen Sie fest ob das Plugin aktiv ist.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Die angezeigten Bankdaten beziehen sich auf')}</span>
            </div>
            <select id="selectedCountry" name="selectedCountry" class="form-control">
                <Option {if $pluginConfig->selectedCountry=='invoice'} selected {/if} value="invoice">{__('Die Rechnungsadresse')}</Option>
                <Option {if $pluginConfig->selectedCountry=='shipping'} selected {/if} value="shipping">{__('Die Lieferadresse')}</Option>
            </select>
            <div class="input-group-append" data-section="selectedCountry">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Sie bestimmen, auf welches Land sich die zusätzlichen Bankdaten beziehen.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>


        <!-- ab hier kommen die individuellen Einstellungen -->

    </fieldset>


    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="defaultselector">{__('Selektoren und Einfügemethoden der einzelnen Bereiche')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Verwendung der Selektoren.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Default Konfiguration Templates')}</span>
            </div>
            <button data-template="nova" class="form-control btn btn-default" type="button">Nova / Admorris</button>
            <button data-template="snackys" class="form-control btn btn-default" type="button">Snackys</button>
            <button data-template="salepix" class="form-control btn btn-default" type="button">Salepix</button>
            <button data-template="easytemplate" class="form-control btn btn-default" type="button">easytemplate</button>
            <div class="input-group-append" data-section="defaultselector">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selectoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Selector')}</span>
            </div>
            <input type="text" name="selector" class="form-control" value="{$pluginConfig->selector}"
                   placeholder="{__('Bitte den Selector eintragen')}">
            <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selectoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>
        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Einfügemethode')}</span>
            </div>
            <select id="selector_position_detail" name="selector_position" class="form-control">
                <Option {if $pluginConfig->selector_position=='off'} selected {/if} value="off">{__('Deaktiviert')}</Option>
                <Option {if $pluginConfig->selector_position=='prepend'} selected {/if}
                        value="prepend">{__('Am Anfang des Elements')}</Option>
                <Option {if $pluginConfig->selector_position=='append'} selected {/if} value="append">{__('Am Ende des Elements')}</Option>
                <Option {if $pluginConfig->selector_position=='before'} selected {/if} value="before">{__('vor dem Element')}</Option>
                <Option {if $pluginConfig->selector_position=='after'} selected {/if} value="after">{__('Nach dem Element')}</Option>
                <Option {if $pluginConfig->selector_position=='html'} selected {/if}
                        value="html">{__('Inhalt des Elements ersetzen')}</Option>
            </select>
            <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Einfügemethode fest oder deaktivieren diese Option.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

    </fieldset>


    <fieldset class="border p-2 form-group css-example">
        <legend>Vorgehensweise zur Einbindung in E-Mails</legend>

        <div class="text-left">
            <p>
                Damit der QR-CODE auch in den E-Mails an Ihre Kunden angezeigt wird
                fügen Sie in Ihrer E-Mail Vorlage, einfach die Variable <span
                        style="color:#1ca2f2; font-size:1.2rem">{literal}{$qrcode}{/literal}</span> an geeigneter Stelle (in dem Bereich, wo
                bei dem die Überweisungsdaten angegeben werden) ein.
            </p>


            <h4>Beispiel, so sollte der Bereich in der HTML Vorlage dann aussehen:</h4>

            {literal}
                <textarea class="form-control css-codemirror smarty readonly" id="docusmarty1">
    {if $Bestellung->Zahlungsart->cModulId === 'za_ueberweisung_jtl'}
        {if !empty($qrcode)}
            {$qrcode}
        {/if}
    {elseif $Bestellung->Zahlungsart->cModulId === 'za_nachnahme_jtl'}</textarea>
            {/literal}

            <h4 style="margin-top:1.5rem;">So sollte der Bereich in der TXT Vorlage dann aussehen:</h4>

            {literal}
                <textarea class="form-control css-codemirror smarty readonly" id="docusmarty2">
    {if $Bestellung->Zahlungsart->cModulId === 'za_ueberweisung_jtl'}
        {if !empty($qrcodeText)}
            {$qrcodeText}
        {/if}
    {elseif $Bestellung->Zahlungsart->cModulId === 'za_nachnahme_jtl'}</textarea>
            {/literal}
        </div>

    </fieldset>


    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="css_js">
            {__('Zusätzliche Styles/ JavaScript')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Nutzung des JS / CSS.')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
        </legend>


        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Styles')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror sass" id="css"
                          name="css">{$pluginConfig->css}</textarea>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('JavaScript')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror JavaScript" id="js"
                          name="js">{$pluginConfig->js}</textarea>
            </div>
        </div>

    </fieldset>

    <div class="save-wrapper">
        <div class="ml-auto col-sm-6 col-xl-auto">
            <button name="a" type="submit" value="" class="btn btn-outline-primary btn-block save">
                <i class="fas fa-save"></i>&nbsp;{__('Konfiguration speichern')}
            </button>
        </div>
    </div>
</form>

<script>
  $(function() {
    $(document).on("change","#pluginActive", function() {
      $(this).removeClass("pluginActive-Y pluginActive-N").addClass("pluginActive-" + $(this).val()).blur();
    });
    $("#pluginActive").trigger("change");
  });
</script>