<?php declare(strict_types=1);

namespace Plugin\css_transferCode\Migrations;

use JTL\Shop;
use JTL\Jtllog;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20251109123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20251109123301 extends Migration implements IMigration {
	/**
	 * @inheritdoc
	 */


	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function up() {
		if(!$this->columnExist('css_transferCodeData', 'currency')) {
			$this->execute("
			ALTER TABLE `css_transferCodeData` ADD `currency` VARCHAR(5) NOT NULL DEFAULT '-1'
			");
		}

		if(($obj = $this->tableExist('css_transferCodeConfig')) && $obj->Rows > 0) {
			$this->execute("UPDATE css_transferCodeConfig set `version` = '2.3.0' ");
		} else {
			$this->execute(
				"INSERT INTO `css_transferCodeConfig` (`version`) VALUES ('2.3.0')"
			);
		}


	}

	/**
	 * @inheritdoc
	 */
	public function down() {
	}
}
