<?php declare(strict_types=1);

namespace Plugin\css_transferCode\Migrations;

use JTL\Shop;
use JTL\Jtllog;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20210429123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20210429123301 extends Migration implements IMigration {
	/**
	 * @inheritdoc
	 */


	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function copyTable($sourceDB, $destinationDB = "", $copyTable = true, $deleteSourceDB = false) {
		error_log('starte copy ' . $sourceDB);
		$result = $this->getDB()->query("SHOW TABLES LIKE '" . $sourceDB . "'", 2);
		if ($copyTable && $result !== null && is_array($result) && count($result)) {
			error_log('DB Vorhanden ' . $sourceDB);
			$result = $this->getDB()->query("SELECT * FROM " . $sourceDB . " WHERE 1", 2);
			foreach ($result as $oItem) {
				error_log('schreibe Datensatz nach ' . $destinationDB);
				$this->getDB()->insert($destinationDB, $oItem);
			}
		}
		if ($deleteSourceDB) {
			$this->execute("DROP TABLE IF EXISTS " . $sourceDB, 3);
		}
	}



	public function up() {
		$this->execute("
              CREATE TABLE IF NOT EXISTS `css_transferCodeConfig` (
                  `version` varchar(10) NOT NULL DEFAULT '1.0.0',
                  `sqlupdate` int(10) NOT NULL DEFAULT '0',
                  `pluginActive` char(1) NOT NULL default 'N',
                  `framework` char(20) NOT NULL default 'B4',
                  `css` text NOT NULL,
                  `js` text NOT NULL,
                  `selector` varchar(100) NOT NULL DEFAULT '#content',
                  `selector_position` varchar(15) NOT NULL DEFAULT 'prepend'
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");


		if(($obj = $this->tableExist('css_transferCodeConfig')) && $obj->Rows > 0) {
			$this->execute("UPDATE css_transferCodeConfig set `version` = '1.0.0' ");
		} else {
			$this->execute(
				"INSERT INTO `css_transferCodeConfig` (`version`) VALUES ('1.0.0')"
			);
		}


	}

	/**
	 * @inheritdoc
	 */
	public function down() {
	}
}
