    $(function () {
        $('textarea[data-editor]').each(function () {
            let textarea = $(this), minHeight = 300, minWidth = 590;
            if (textarea.height() > minHeight) {
                minHeight = textarea.height();
            }
            // predefined width
            if (textarea.data('width')) {
                minWidth = textarea.data('width');
            } else if (textarea.width() > minWidth) {
                minWidth = textarea.width();
            }
            let editDiv = $('<div>', {
                    position: 'absolute',
                    width: minWidth,
                    height: minHeight,
                    'class': textarea.attr('class')
                }).insertBefore(textarea),
                editor = ace.edit(editDiv[0]);

            textarea.css('display', 'none');
            editor.renderer.setShowGutter(textarea.data('gutter'));
            editor.getSession().setValue(textarea.val());
            editor.getSession().setMode("ace/mode/" + textarea.data('editor'));
            editor.setTheme("ace/theme/xcode");

            // enable autocompletion
            if (textarea.data('autocomplete')) {
                ace.require("ace/ext/language_tools");
                editor.setOptions({
                    enableBasicAutocompletion: true,
                    enableSnippets: true,
                    enableLiveAutocompletion: true,
                    showLineNumbers: true
                });
            }

            textarea.closest('form').submit(function () {
                textarea.val(editor.getSession().getValue());
            });
            textarea.removeAttr('style').hide();
        });
    });
