<?php declare(strict_types=1);

namespace Plugin\css_minValue\Migrations;

use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20240331123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20240331123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */


	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}



    public function up()    {

	    $this->execute("
										ALTER TABLE `css_minValueConfig` CHANGE `version` `version` VARCHAR(10)
										");

	    if($this->columnExist('css_minValueConfig', 'product_selector')==false) {
		    $this->execute("
										ALTER TABLE `css_minValueConfig`
										    ADD `product_selector` varchar(255) NOT NULL DEFAULT '#add-to-cart'
										");
			}

	    if($this->columnExist('css_minValueConfig', 'product_selector_position') == false) {
		    $this->execute("
										ALTER TABLE `css_minValueConfig`
										    ADD `product_selector_position` varchar(15) NOT NULL DEFAULT 'after'
										");
			}



	    if($this->columnExist('css_minValueConfig', 'cartCalculation')==false) {
		    $this->execute("
										ALTER TABLE `css_minValueConfig`
										    ADD `cartCalculation` char(1) NOT NULL DEFAULT 'P'
										");
	    }


	    if(($obj = $this->tableExist('css_minValueConfig')) && $obj->Rows > 0) {
		    $this->execute("UPDATE css_minValueConfig set `version` = '2.2.2' ");
	    } else {
		    $this->execute(
			    "INSERT INTO `css_minValueConfig` (`version`) VALUES ('2.2.2')"
		    );
	    }


    }

    /**
     * @inheritdoc
     */
    public function down() {
    }
}
