<?php declare(strict_types=1);

namespace Plugin\css_minValue\Migrations;

use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20230301123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20230301123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */



	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function up()    {
        $this->execute("
              CREATE TABLE IF NOT EXISTS `css_minValueData` (
                  `ISOCode` char(3) NOT NULL DEFAULT '',
                  `minValue` int(10) NOT NULL DEFAULT '0'
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");

        $result = $this->getDB()->query(
            'SELECT * from `css_minValueConfig` where 1',
            2
        );

// umstellung auf individuelle konfiguration der Lnder
	    $obj = $this->getDB()->query("Show columns from css_minValueConfig like 'minValue' ",1);
	    if($obj !== null && isset($obj->Field)) {

		    $result = $this->getDB()->query(
			    'SELECT * from `css_minValueConfig` where 1',
			    1
		    );

		    if(!empty($result->ISOCode)) {
			    $aISOCode =  explode(",", $result->ISOCode);
			    $obj = new \stdClass();
			    $obj->minValue = (int)$result->minValue;
					foreach($aISOCode as $code) {
						$obj->ISOCode = trim($code);
						$this->getDB()->insert('css_minValueData', $obj);
					}
			    $this->execute("
										ALTER TABLE `css_minValueConfig`
										    ADD `showModal` char(1) NOT NULL DEFAULT 'N'
										");
			    $this->execute("
										ALTER TABLE `css_minValueConfig`
										  DROP `minValue`,
										  DROP `ISOCode`"
			    );
		    }
	    }

	    if(($obj = $this->tableExist('css_minValueConfig')) && $obj->Rows > 0) {
		    $this->execute("UPDATE css_minValueConfig set `version` = '2.2.0' ");
	    } else {
		    $this->execute(
			    "INSERT INTO `css_minValueConfig` (`version`) VALUES ('2.2.0')"
		    );
	    }

    }

    /**
     * @inheritdoc
     */
    public function down() {
    }
}
