{inline_script}
<script>
    {$lgZoom = ($oCssGalleryConfig->lightGallery->lightGallery_zoom == 'Y') ? 'lgZoom,' : ''}
    {$download = ($oCssGalleryConfig->lightGallery->lightGallery_download == 'Y') ? 'download,' : ''}
    {$lgRotate = ($oCssGalleryConfig->lightGallery->lightGallery_rotate == 'Y') ? 'lgRotate,' : ''}
    {$lgFullscreen = ($oCssGalleryConfig->lightGallery->lightGallery_fullscreen == 'Y') ? 'lgFullscreen,' : ''}
    {$lgShare = ($oCssGalleryConfig->lightGallery->lightGallery_share == 'Y') ? 'lgShare,' : ''}
    {$oneClick = ($oCssGalleryConfig->lightGallery->lightGallery_zoom_function == 'click') ? true : false}

  (function( $ ){
    $.fn.cssCreateGallery = function(options){

      this.settings = $.extend({
        kArtikel: 0,
        thumbail_position: 'B',
        imageCount: 0,
        oneClick: false
      }, options );

      this.cssLG =   "";
      this.MousePosition = 0;
      this.touchStartPos = 0;
      this.touchEndPos = 0;
      this.resizeTimer = 0;
      this.GalleryId = 'css-gallery-'+ this.settings.kArtikel;
      this.lgContainer = '';

      this.ChangeMode = function() {
        if(this.settings.thumbail_position == 'B'){
          return;
        }
        var cssInnerWidth = $("#" + that.lgContainer + " " + ".lg-inner .lg-current img").width();
//        var cssInnerWidth = $("#" + that.lgContainer + " " + ".lg-inner .lg-current .lg-has-youtube").width();


        if($( "#" + that.lgContainer + " " + ".lg-outer" ).width() > $(  "#" + that.lgContainer +  " " +".lg-outer" ).height() && Number(cssInnerWidth+300) < $( "#" + that.lgContainer +  " " + ".lg-outer").width() ) {
          $( "#" + that.lgContainer +  " " + ".lg-thumb-outer").appendTo("#" + that.lgContainer +  " " + '.lg-outer');
          var cssComponents = $("#" + that.lgContainer +  " " + ".lg-components").outerHeight();
          $("#" + that.lgContainer +  " " + ".lg-content").css({
            bottom: cssComponents + "px",
            margin: "20px 0 0 250px"
          });
          $("#" + that.lgContainer +  " " + ".lg-components").css({
            bottom: 0,
            margin: "0 0 0 250px"
          });
        } else {
          $("#" + that.lgContainer +  " " + ".lg-thumb-outer").appendTo("#" + that.lgContainer +  " " + '.lg-components');
          var cssComponents = $("#" + that.lgContainer +  " " + ".lg-components").outerHeight();
          $("#" + that.lgContainer +  " " + ".lg-content").css({
            margin: "20px 0 0 0",
            bottom: cssComponents + "px",
          });
          $("#" + that.lgContainer +  " " + ".lg-components").css({
            margin: "0 0 0 0"
          });
        }
      };

      this.createEventListener = function() {
        var lg = document.getElementById("css-gallery-" + this.settings.kArtikel);

        // verhindert einen Fehler mit der Zoom, Funktion
        lg.addEventListener('lgHasVideo', (event) => {
          const { index, prevIndex } = event.detail;
          $(".lg-video-poster").addClass("lg-image has-video");
        });

        lg.addEventListener('lgBeforeSlide', (event) => {
          const {
            index,
            prevIndex
          } =
            event.detail;
          if(this.settings.imageCount) {
                $("#css-gallery-" + this.settings.kArtikel ).slick('slickGoTo', parseInt(index));
          }
        });

        lg.addEventListener('lgAfterOpen', (event) => {
          $(".lg-video-poster").addClass("lg-image");
          $(".lg-content .lg-video-cont").each(function() {
            var id = $(this).parent().index();
//            console.log("Index: "+id);
          })
          this.ChangeMode();
        });
      };


      this.oneClick = function() {
        if(!this.settings.oneClick) {   return; }
        $(document).on("mousemove touchmove", "#" + that.lgContainer +  " " + ".lg-outer:not(.lg-zoomed)", function(e) {
          if(typeof e.clientX !== "undefined") {
            MousePosition = e.clientX;
          }
        });

        $(document).on("mousedown mouseup", "#" + that.lgContainer +  " " + ".lg-outer:not(.lg-zoomed) .lg-current", function(e) {
          $("#" + that.lgContainer +  " " + ".lg-outer").trigger('mousemove');
          if(e.type=='mousedown' ) {
            that.touchStartPos = MousePosition;
            return true;
          }
          if(e.type=='mouseup' ) {
            that.touchEndPos = MousePosition;
            if(that.touchStartPos != that.touchEndPos) {
              return true;
            } else {
              $("#" + that.lgContainer +  " " + '.lg-zoom-in').trigger("click");
              return true;
            }
          }
        });
      }

      this.createSlickGallery = function() {
        var NavFor = '#css-gallery_preview-' + this.settings.kArtikel;
        var cssUseArrows = '#css-gallery-' + this.settings.kArtikel;
        if(!this.settings.imageCount) {
          NavFor = false
        }
        {if $isMobile}
            cssUseArrows = false;
        {/if}

        var sl = $("#css-gallery-" + this.settings.kArtikel).slick({
          arrows: true,
          infinite: true,
          appendArrows: cssUseArrows,
          speed: 500,
          asNavFor: NavFor,
        });
      };

      this.createSlickThumbs = function() {
        $("#css-gallery_preview-"+ this.settings.kArtikel).slick({
          arrows: true,
          infinite: true,
          //          vertical: true,
          speed: 500,
          //          fade: true,
          //          cssEase: 'linear',
          appendArrows: '#css-gallery_preview_wrapper-'+ this.settings.kArtikel,
          slidesToShow: {(int) $oCssGalleryConfig->lightGallery->lightGallery_breakpoint_defaut|default:6},
          slidesToScroll: 1,
          asNavFor: '#css-gallery-'+ this.settings.kArtikel,
          focusOnSelect: true,
          centerMode: false,
          preload: 1,
          getCaptionFromTitleOrAlt: {if $oCssGalleryConfig->lightGallery->gallery_show_caption=='Y'}true{else}false{/if},

          // mobileFirst: true,
          respondTo: 'slider',
          responsive: [
            {
              breakpoint: 700,
              settings: {
                slidesToShow: {(int) $oCssGalleryConfig->lightGallery->lightGallery_breakpoint_700|default:8},
                arrows: true,
              }
            },
            {
              breakpoint: 540,
              settings: {
                slidesToShow: {(int) $oCssGalleryConfig->lightGallery->lightGallery_breakpoint_540|default:7},
                arrows: true,
              }
            },
            {
              breakpoint: 450,
              settings: {
                slidesToShow: {(int) $oCssGalleryConfig->lightGallery->lightGallery_breakpoint_450|default:5},
                arrows: true,
              }
            },
            {
              breakpoint: 300,
              settings: {
                slidesToShow: {(int) $oCssGalleryConfig->lightGallery->lightGallery_breakpoint_300|default:4},
                arrows: true,
              }
            },
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
          ]
        });
      }


      this.createLightGallery = function() {
        var lg = document.getElementById("css-gallery-" + this.settings.kArtikel);
        lg.addEventListener('lgContainerResize', (event) => {
          clearTimeout(this.resizeTimer);
//          console.log("timer ",event);
          that.resizeTimer = setTimeout(function() {
//            console.log("containerresize");
            that.ChangeMode();
          }, 250);

          //          this.ChangeMode();
        });

        that.cssLG = lightGallery(lg, {
          plugins: [ {$lgZoom} {$lgRotate} {$lgFullscreen} {$lgShare} lgThumbnail,lgVideo],
            {$iCssGallery->getLightGallery()}
          speed: {(int) $oCssGalleryConfig->lightGallery->lightGallery_speed},
          mode: '{$oCssGalleryConfig->lightGallery->lightGallery_mode}',
          controls: true, showCloseIcon: true , download: {if $download != ''}true{else}false{/if},
          exThumbImage: 'data-external-thumb-image-' + this.settings.kArtikel,
          allowMediaOverlap: false,
          animateThumb: true,
          toggleThumb: true,
          mousewheel: true,
          alignThumbnails : 'middle',
          preload: 'none',
          autoplayVideoOnSlide : false,
          autoplayFirstVideo: false,
          exThumbImage: 'data-external-thumb-image',
          loadYouTubeThumbnail:false,
          getCaptionFromTitleOrAlt:{if $oCssGalleryConfig->lightGallery->gallery_show_caption=='Y'}true{else}false{/if},
          youtubePlayerParams: {
            modestbranding: 1,
            showinfo: 0,
            rel: 0,
            controls: 1,
            muted:false
          },
          vimeoPlayerParams: {
            byline : 1,
            muted:false,
            portrait : 1,
            autoplay:0,
            color : '#f90000'
          },
//    appendThumbnailsTo:'.lg-outer',
          mobileSettings: {
            plugins: [{$lgZoom} {$lgRotate} {$lgShare} lgThumbnail, lgVideo],
            controls: false, showCloseIcon: true , download: {if $download != ''}true{else}false{/if},
            addClass: null,
            animateThumb: true,
            allowMediaOverlap: false,
            toggleThumb: false,
          },
            {*if $lgShare!=''}facebook: false,{/if*}

        });

        this.lgContainer = $(this.cssLG.$container.selector).attr("id");
      };

      var that = this;
      this.createLightGallery();

        this.createSlickGallery();
        this.createSlickThumbs();
        this.createEventListener();
        this.oneClick();

/*
      $(window).on('resize', function(e) {

      });
*/


      return this;
    }
  })( jQuery );

</script>
{/inline_script}