{if !empty($cHinweis)}
    <div class="alert alert-success">{$cHinweis}</div>{/if}
{if !empty($cError)}
    <div class="alert alert-danger">{$cError}</div>{/if}

<form method="post" action="{$cssPlugin->getPluginLink()}" data-plugin="{$oPlugin->getPluginID()}" data-io="{$cssPlugin->getAdminIOLink()}"
      data-session="{$smarty.session.jtl_token}">
    {$jtl_token}
    <input type="hidden" name="cssAdminConfigAction" value="saveConfig"/>


    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="plugin">{__('Plugin Konfiguration')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Funktionsweise des Plugins.')}">
                <span class="fas fa-info-circle fa-fw"> </span>
            </span>
            <div class="css-tooltip">
                Über dieses Symbol erhalten Sie die Erklärung der jeweiligen Funktionen und Einstellungen
                <div class="css-close"><i class="fa fa-close"></i></div>
            </div>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Das Plugin ist')}</span>
            </div>
            <select id="pluginActive" name="pluginActive" class="form-control">
                <Option {if $pluginConfig->pluginActive=='Y'} selected {/if} value="Y">{__('Aktiviert')}</Option>
                <Option {if $pluginConfig->pluginActive=='N'} selected {/if} value="N">{__('Deaktiviert')}</Option>
            </select>
            <div class="input-group-append" data-section="active">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen Sie fest ob das Plugin aktiv ist.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <!-- ab hier kommen die individuellen Einstellungen -->
    </fieldset>

    <fieldset class="border p-2 form-group">
        <legend class="w-auto">{__('Template Konfiguration')}</legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Template Framework')}</span>
            </div>
            <select id="framework" name="framework" class="form-control">
                <Option {if $pluginConfig->framework=='B4'} selected {/if} value="B4">{__('Bootstrap 4 (z.B. NOVA)')}</Option>
                {if isset($bHasCustom)}
                    <Option {if $pluginConfig->framework=='custom'} selected {/if}
                            value="custom">{__('Custom (Ihre eigene updatesichere Pluginmodifikation)')}</Option>
                {/if}
            </select>
            <div class="input-group-append" data-section="framework">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier geben Sie an, welches Framework Ihr Template nutzt, Wenn Sie es nicht wissen, fragen Sie bitte den Hersteller des Templates.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>
        <div class="input-group mb-3" style="margin-top:-17px;">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Default Konfiguration Templates')}</span>
            </div>
            <button data-template="nova" class="form-control btn btn-default" type="button">Nova</button>
            <button data-template="admorris" class="form-control btn btn-default" type="button">Admorris</button>
            <button data-template="snackys" class="form-control btn btn-default" type="button">Snackys</button>
            <button data-template="salepix" class="form-control btn btn-default" type="button">Salepix</button>
            <button data-template="easytemplate" class="form-control btn btn-default" type="button">easytemplate</button>
            <div class="input-group-append" data-section="defaultselector">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selektoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
            </div>
        </div>

        <fieldset class=" p-2 form-group" style="border:1px solid #5cbcf6; margin:10px 35px; ">
            <legend class="w-auto" data-section="selector_gallery">
                {__('Selektor der Galerie')}
                <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                      data-original-title="{__('Selektor')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
            </legend>

            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Selektor')}</span>
                </div>
                <input type="text" name="selector_gallery" class="form-control" value="{$pluginConfig->selector_gallery}"
                       placeholder="{__('')}">
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selektoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Modifikationstype')}</span>
                </div>
                <select id="selector_gallery_position" name="selector_gallery_position" class="form-control">
                    <Option {if $pluginConfig->selector_gallery_position=='off'} selected {/if} value="off">{__('Deaktiviert')}</Option>
                    <Option {if $pluginConfig->selector_gallery_position=='prepend'} selected {/if}
                            value="prepend">{__('Am Anfang des Elements')}</Option>
                    <Option {if $pluginConfig->selector_gallery_position=='append'} selected {/if}
                            value="append">{__('Am Ende des Elements')}</Option>
                    <Option {if $pluginConfig->selector_gallery_position=='before'} selected {/if}
                            value="before">{__('vor dem Element')}</Option>
                    <Option {if $pluginConfig->selector_gallery_position=='after'} selected {/if}
                            value="after">{__('Nach dem Element')}</Option>
                    <Option {if $pluginConfig->selector_gallery_position=='html'} selected {/if}
                            value="html">{__('Inhalt des Elements ersetzen')}</Option>
                </select>
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen den  Modifikationstypen fest oder deaktivieren diese Option.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
        </fieldset>

        <fieldset class=" p-2 form-group" style="border:1px solid #5cbcf6; margin:10px 35px; ">
            <legend class="w-auto" data-section="selector_thumbnails">
                {__('Selektor der Der Thumbnails in der Galerie')}
                <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                      data-original-title="{__('Selektor')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
            </legend>

            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Selektor')}</span>
                </div>
                <input type="text" name="selector_thumbnails" class="form-control" value="{$pluginConfig->selector_thumbnails}"
                       placeholder="{__('')}">
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen die Selektoren fest.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Modifikationstype')}</span>
                </div>
                <select id="selector_thumbnails_position" name="selector_thumbnails_position" class="form-control">
                    <Option {if $pluginConfig->selector_thumbnails_position=='off'} selected {/if} value="off">{__('Deaktiviert')}</Option>
                    <Option {if $pluginConfig->selector_thumbnails_position=='prepend'} selected {/if}
                            value="prepend">{__('Am Anfang des Elements')}</Option>
                    <Option {if $pluginConfig->selector_thumbnails_position=='append'} selected {/if}
                            value="append">{__('Am Ende des Elements')}</Option>
                    <Option {if $pluginConfig->selector_thumbnails_position=='before'} selected {/if}
                            value="before">{__('vor dem Element')}</Option>
                    <Option {if $pluginConfig->selector_thumbnails_position=='after'} selected {/if}
                            value="after">{__('Nach dem Element')}</Option>
                    <Option {if $pluginConfig->selector_thumbnails_position=='html'} selected {/if}
                            value="html">{__('Inhalt des Elements ersetzen')}</Option>
                </select>
                <div class="input-group-append">
                <span class="input-group-text">
                    <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                          data-original-title="{__('Hier legen den Modifikationstypen fest oder deaktivieren diese Option.')}">
                        <span class="fas fa-info-circle fa-fw"></span>
                    </span>
               </span>
                </div>
            </div>
        </fieldset>
    </fieldset>


    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="config_gallery">
            {__('Galerie Einstellungen')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung.')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
        </legend>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Darstellung der Thumbnails')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">

                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Style</div>
                        <select id="thumbnail_border_style" name="lightGallery[thumbnail_border_style]" class="form-control">
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='none'} selected {/if}
                                    value="none">{__('none')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='solid'} selected {/if}
                                    value="solid">{__('solid')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='dotted'} selected {/if}
                                    value="dotted">{__('dotted')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='dashed'} selected {/if}
                                    value="dashed">{__('dashed')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='double'} selected {/if}
                                    value="double">{__('double')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='groove'} selected {/if}
                                    value="groove">{__('groove')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='ridge'} selected {/if}
                                    value="ridge">{__('ridge')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='inset'} selected {/if}
                                    value="inset">{__('inset')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->thumbnail_border_style) && $pluginConfig->lightGallery->thumbnail_border_style=='outset'} selected {/if}
                                    value="outset">{__('outset')}</Option>
                        </select>
                    </div>
                </div>


                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Breite in px</div>
                        <input type="text" name="lightGallery[thumbnail_border_width]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_border_width|default:"0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Radius in px</div>
                        <input type="text" name="lightGallery[thumbnail_border_radius]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_border_radius|default:"0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe des Borders</div>
                        <input type="text" name="lightGallery[thumbnail_border_color]" class="form-control "
                               value="{$pluginConfig->lightGallery->thumbnail_border_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Aktive Farbe des Borders</div>
                        <input type="text" name="lightGallery[thumbnail_active_border_color]" class="form-control cssColorPicker"
                               value="{$pluginConfig->lightGallery->thumbnail_active_border_color|default:"#fbc0c0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
            </div>
        </div>
<hr>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Darstellung der Thumbnail Pfeile')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe</div>
                        <input type="text" name="lightGallery[thumbnail_arrow_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_arrow_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Farbe</div>
                        <input type="text" name="lightGallery[thumbnail_arrow_hover_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_arrow_hover_color|default:"#fb000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[thumbnail_arrow_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_arrow_bgcolor|default:"transparent"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[thumbnail_arrow_hover_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->thumbnail_arrow_hover_bgcolor|default:"transparent"}"
                               placeholder="{__('')}">
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Darstellung der Galerie Pfeile')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe</div>
                        <input type="text" name="lightGallery[gallery_arrow_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_arrow_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Farbe</div>
                        <input type="text" name="lightGallery[gallery_arrow_hover_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_arrow_hover_color|default:"#fbc0c0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[gallery_arrow_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_arrow_bgcolor|default:"#d1d1d1"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[gallery_arrow_hover_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_arrow_hover_bgcolor|default:"#fbc0c0"}"
                               placeholder="{__('')}">
                    </div>
                </div>

            </div>
        </div>

<hr>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Caption Anzeige')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Caption</div>
                        <select id="gallery_show_caption" name="lightGallery[gallery_show_caption]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->gallery_show_caption=='Y'} selected {/if}
                                    value="Y">{__('anzeigen')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_show_caption=='N'} selected {/if}
                                    value="N">{__('nicht anzeigen')}</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Schriftgröße (px/em)px</div>
                        <input type="text" name="lightGallery[gallery_caption_fontSize]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_caption_fontSize|default:"14px"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Schrift Style</div>
                        <select id="gallery_caption_fontStyle" name="lightGallery[gallery_caption_fontStyle]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='N'} selected {/if}
                                    value="Y">{__('Normal')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='B'} selected {/if}
                                    value="B">{__('Bold')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='I'} selected {/if}
                                    value="I">{__('Italic')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='U'} selected {/if}
                                    value="U">{__('Underline')}</Option>
                            <Option {if $pluginConfig->gallery_caption_fontStyle=='B|I'} selected {/if}
                                    value="B|I">{__('Bold & Italic')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='B|U'} selected {/if}
                                    value="B|U">{__('Bold & Underline')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='I|U'} selected {/if}
                                    value="I|U">{__('Italic & Underline')}</Option>
                            <Option {if $pluginConfig->lightGallery->gallery_caption_fontStyle=='B|I|U'} selected {/if}
                                    value="B|I|U">{__('Bold & Italic & Underline')}</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe</div>
                        <input type="text" name="lightGallery[gallery_caption_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_caption_color|default:"#fbc0c0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[gallery_caption_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->gallery_caption_bgcolor|default:"#d1d1d1"}"
                               placeholder="{__('')}">
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="input-group mb-3 css-strech" id="css-breakpoints">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Thumbnail Breakpoints')}</span>
            </div>


            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">default</div>
                        <select id="lightGallery_breakpoint_default" name="lightGallery[lightGallery_breakpoint_default]" class="form-control" data-default="6">
                            {$breakpoint = $pluginConfig->lightGallery->lightGallery_breakpoint_default|default:6}
                            {for $var=2 to 10}
                                <Option {if $breakpoint == $var} selected {/if}
                                        value="{$var}">{$var}</Option>
                            {/for}
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">bis 700px</div>
                        <select id="lightGallery_breakpoint_700" name="lightGallery[lightGallery_breakpoint_700]" class="form-control"  data-default="8">
                            {$breakpoint = $pluginConfig->lightGallery->lightGallery_breakpoint_700|default:8}
                            {for $var=2 to 10}
                                <Option {if $breakpoint == $var} selected {/if}
                                        value="{$var}">{$var}</Option>
                            {/for}
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">bis 540px</div>
                        <select id="lightGallery_breakpoint_540" name="lightGallery[lightGallery_breakpoint_540]" class="form-control" data-default="7">
                            {$breakpoint = $pluginConfig->lightGallery->lightGallery_breakpoint_540|default:7}
                            {for $var=2 to 10}
                                <Option {if $breakpoint == $var} selected {/if}
                                        value="{$var}">{$var}</Option>
                            {/for}
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">bis 450px</div>
                        <select id="lightGallery_breakpoint_450" name="lightGallery[lightGallery_breakpoint_450]" class="form-control" data-default="5">
                            {$breakpoint = $pluginConfig->lightGallery->lightGallery_breakpoint_450|default:5}
                            {for $var=2 to 10}
                                <Option {if $breakpoint == $var} selected {/if}
                                        value="{$var}">{$var}</Option>
                            {/for}
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">bis 300px</div>
                        <select id="lightGallery_breakpoint_300" name="lightGallery[lightGallery_breakpoint_300]" class="form-control" data-default="4">
                            {$breakpoint = $pluginConfig->lightGallery->lightGallery_breakpoint_300|default:4}
                            {for $var=2 to 10}
                                <Option {if $breakpoint == $var} selected {/if}
                                        value="{$var}">{$var}</Option>
                            {/for}
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                        <button
                                class="form-control btn btn-info"
                                style="border-radius:0; height:100%; font-size:13px; font-weight:bold; color:#fff"
                                type="button"
                                onclick='$("#css-breakpoints select").each(function() { $(this).val($(this).data("default"));});'
                        >Einstellung zurücksetzen</button>
                </div>
                <div class="input-group-append" data-section="breakpoints"  style="display:block; max-width:30px; height:100%">
                    <span class="input-group-text" style="height:100%; justify-content:center; background-color:transparent !important;">
                        <span data-html="true" data-toggle="tooltip" data-placement="left" title="" data-original-title="Menge der Thumbnails je Containerbreite" >
                            <span class="fas fa-info-circle fa-fw"></span>
                        </span>
                   </span>
                </div>

            </div>
        </div>
        <hr>
        <div class="input-group mb-3 css-strech" id="css-breakpoints">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Video Einstellung')}</span>
            </div>

            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">Video in Galerie anzeigen</div>
                        <select id="lightGallery_video_active" name="lightGallery[lightGallery_video_active]" class="form-control" data-default="N">
                            {$videoActive = $pluginConfig->lightGallery->lightGallery_video_active|default:N}
                                <Option {if $videoActive =='N'} selected {/if}
                                        value="N">deaktiviert</Option>
                                <Option {if $videoActive =='Y'} selected {/if}
                                        value="Y">Aktiviert</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">Video Position</div>
                        <select id="lightGallery_video_position" name="lightGallery[lightGallery_video_position]" class="form-control" data-default="A">
                            {$videoPos = $pluginConfig->lightGallery->lightGallery_video_position|default:P}
                                <Option {if $videoPos =='P'} selected {/if}
                                        value="P">Am Anfang</Option>
                                <Option {if $videoPos =='A'} selected {/if}
                                        value="A">Am Ende</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append" data-section="video"  style="display:block; max-width:30px; height:100%">
                    <span class="input-group-text" style="height:100%; justify-content:center; background-color:transparent !important;">
                        <span data-html="true" data-toggle="tooltip" data-placement="left" title="" data-original-title="Video Option" >
                            <span class="fas fa-info-circle fa-fw"></span>
                        </span>
                   </span>
                </div>
            </div>

    </fieldset>

    <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="config_lightgallery">
            {__('lightGallery Konfiguration')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung.')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
        </legend>

        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Zusatzfunktionen')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">Bilder Download</div>
                        <select id="lightGallery_download" name="lightGallery[lightGallery_download]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_download=='N'} selected {/if}
                                    value="N">{__('nicht erlaubt')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_download=='Y'} selected {/if}
                                    value="Y">{__('erlaubt')}</Option>
                        </select>
                    </div>
                    <div>
                        <div class="input-group-text css-blue">Zoom über</div>
                        <select id="lightGallery_zoom_function" name="lightGallery[lightGallery_zoom_function]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_zoom_function=='click'} selected {/if}
                                    value="click">{__('einfachklick')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_zoom_function=='doubleclick'} selected {/if}
                                    value="doubleclick">{__('doppelklick default')}</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">Bild Rotation</div>
                        <select id="lightGallery_rotate" name="lightGallery[lightGallery_rotate]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_rotate=='N'} selected {/if}
                                    value="N">{__('deaktiviert')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_rotate=='Y'} selected {/if}
                                    value="Y">{__('aktiviert')}</Option>
                        </select>
                    </div>
                    <div>
                        <div class="input-group-text css-blue">Thumbnail Position</div>
                        <select id="lightGallery_rotate" name="lightGallery[thumbail_position]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->thumbail_position=='LB'}selected {/if}
                                    value="LB">{__('Breitenabhängig')}</Option>
                            <Option {if $pluginConfig->lightGallery->thumbail_position=='B'} selected{/if}
                                    value="B">{__('unten')}</Option>
                        </select>
                    </div>
                </div>
                <div class="input-group-append" style="display:block;">
                    <div>
                        <div class="input-group-text css-blue">Fullscreen</div>
                        <select id="lightGallery_rotate" name="lightGallery[lightGallery_fullscreen]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_fullscreen=='N'} selected {/if}
                                    value="N">{__('deaktiviert')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_fullscreen=='Y'} selected {/if}
                                    value="Y">{__('aktiviert')}</Option>
                        </select>
                    </div>
                    <div>
                        <div class="input-group-text css-blue">Slide Effekt</div>
                        <select id="lightgallery_mode" name="lightGallery[lightGallery_mode]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-fade'} selected {/if}
                                    value="lg-fade">{__('lg-fade')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide'} selected {/if}
                                    value="lg-slide">{__('lg-slide')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-in'} selected {/if}
                                    value="lg-zoom-in">{__('lg-zoom-in')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-in-big'} selected {/if}
                                    value="lg-zoom-in-big">{__('lg-zoom-in-big')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-out'} selected {/if}
                                    value="lg-zoom-out">{__('lg-zoom-out')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-out-big'} selected {/if}
                                    value="lg-zoom-out-big">{__('lg-zoom-out-big')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-out-in'} selected {/if}
                                    value="lg-zoom-out-in">{__('lg-zoom-out-in')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-zoom-in-out'} selected {/if}
                                    value="lg-zoom-in-out">{__('lg-zoom-in-out')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-soft-zoom'} selected {/if}
                                    value="lg-soft-zoom">{__('lg-soft-zoom')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-scale-up'} selected {/if}
                                    value="lg-scale-up">{__('lg-scale-up')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-circular'} selected {/if}
                                    value="lg-slide-circular">{__('lg-slide-circular')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-circular-vertical'} selected {/if}
                                    value="lg-slide-circular-vertical">{__('lg-slide-circular-vertical')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-vertical'} selected {/if}
                                    value="lg-slide-vertical">{__('lg-slide-vertical')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-vertical-growth'} selected {/if}
                                    value="lg-slide-vertical-growth">{__('lg-slide-vertical-growth')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-only'} selected {/if}
                                    value="lg-slide-skew-only">{__('lg-slide-skew-only')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-only-rev'} selected {/if}
                                    value="lg-slide-skew-only-rev">{__('lg-slide-skew-only-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-only-y'} selected {/if}
                                    value="lg-slide-skew-only-y">{__('lg-slide-skew-only-y')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-only-y-rev'} selected {/if}
                                    value="lg-slide-skew-only-y-rev">{__('lg-slide-skew-only-y-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew'} selected {/if}
                                    value="lg-slide-skew">{__('lg-slide-skew')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-rev'} selected {/if}
                                    value="lg-slide-skew-rev">{__('lg-slide-skew-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-cross'} selected {/if}
                                    value="lg-slide-skew-cross">{__('lg-slide-skew-cross')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-cross-rev'} selected {/if}
                                    value="lg-slide-skew-cross-rev">{__('lg-slide-skew-cross-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-ver'} selected {/if}
                                    value="lg-slide-skew-ver">{__('lg-slide-skew-ver')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-ver-rev'} selected {/if}
                                    value="lg-slide-skew-ver-rev">{__('lg-slide-skew-ver-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-ver-cross'} selected {/if}
                                    value="lg-slide-skew-ver-cross">{__('lg-slide-skew-ver-cross')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-slide-skew-ver-cross-rev'} selected {/if}
                                    value="lg-slide-skew-ver-cross-rev">{__('lg-slide-skew-ver-cross-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-lollipop'} selected {/if}
                                    value="lg-lollipop">{__('lg-lollipop')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-lollipop-rev'} selected {/if}
                                    value="lg-lollipop-rev">{__('lg-lollipop-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-rotate'} selected {/if}
                                    value="lg-rotate">{__('lg-rotate')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-rotate-rev'} selected {/if}
                                    value="lg-rotate-rev">{__('lg-rotate-rev')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_mode=='lg-tube'} selected {/if}
                                    value="lg-tube">{__('lg-tube')}</Option>
                        </select>

                    </div>
                </div>
                <div class="input-group-append" style="display:block">
                    <div>
                        <div class="input-group-text css-blue">Zoom</div>
                        <select id="lightGallery_rotate" name="lightGallery[lightGallery_zoom]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_zoom=='N'} selected {/if}
                                    value="N">{__('deaktiviert')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_zoom=='Y'} selected {/if}
                                    value="Y">{__('aktiviert')}</Option>
                        </select>
                    </div>
                    <div>
                        <div class="input-group-text css-blue">Slide Speed</div>
                        <div>
                            <input type="text" name="lightGallery[lightGallery_speed]" class="form-control"
                                   value="{$pluginConfig->lightGallery->lightGallery_speed|default:"500"}"
                                   placeholder="{__('')}">
                        </div>
                    </div>
                </div>
                <div class="input-group-append" style="display:block">
                    <div>
                        <div class="input-group-text css-blue">Share</div>
                        <select id="lightGallery_rotate" name="lightGallery[lightGallery_share]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_share=='N'} selected {/if}
                                    value="N">{__('deaktiviert')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_share=='Y'} selected {/if}
                                    value="Y">{__('aktiviert')}</Option>
                        </select>
                    </div>
                    <div>
                        <div class="input-group-text css-blue">Zoom Größe</div>
                        <select id="lightGallery_picture" name="lightGallery[lightGallery_picture]" class="form-control">
                            <Option {if $pluginConfig->lightGallery->lightGallery_picture=='lg'} selected {/if}
                                    value="lg">{__('groß')}</Option>
                            <Option {if $pluginConfig->lightGallery->lightGallery_picture=='xl'} selected {/if}
                                    value="xl">{__('Originalgröße (WAWI)')}</Option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

<hr>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Design')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hintergrund</div>
                        <input type="text" name="lightGallery[lg_background_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_background_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Textfarbe</div>
                        <input type="text" name="lightGallery[lg_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Toolbar Hintergrund</div>
                        <input type="text" name="lightGallery[lg_toolbar_background_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_toolbar_background_color|default:"rgba(0,0,0,0.7)"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Toolbar Textfarbe</div>
                        <input type="text" name="lightGallery[lg_toolbar_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_toolbar_color|default:"#999"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Toolbar Hoverfarbe</div>
                        <input type="text" name="lightGallery[lg_toolbar_hover_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_toolbar_hover_color|default:"#fff"}"
                               placeholder="{__('')}">
                    </div>
                </div>

            </div>
        </div>

<hr>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Darstellung der Thumbnails')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">

                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Style</div>
                        <select id="lg_thumbnail_border_style" name="lightGallery[lg_thumbnail_border_style]" class="form-control">
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='none'} selected {/if}
                                    value="none">{__('none')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='solid'} selected {/if}
                                    value="solid">{__('solid')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='dotted'} selected {/if}
                                    value="dotted">{__('dotted')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='dashed'} selected {/if}
                                    value="dashed">{__('dashed')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='double'} selected {/if}
                                    value="double">{__('double')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='groove'} selected {/if}
                                    value="groove">{__('groove')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='ridge'} selected {/if}
                                    value="ridge">{__('ridge')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='inset'} selected {/if}
                                    value="inset">{__('inset')}</Option>
                            <Option {if !empty($pluginConfig->lightGallery->lg_thumbnail_border_style) && $pluginConfig->lightGallery->lg_thumbnail_border_style=='outset'} selected {/if}
                                    value="outset">{__('outset')}</Option>
                        </select>
                    </div>
                </div>


                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Breite in px</div>
                        <input type="text" name="lightGallery[lg_thumbnail_border_width]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_thumbnail_border_width|default:"0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Border Radius in px</div>
                        <input type="text" name="lightGallery[lg_thumbnail_border_radius]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_thumbnail_border_radius|default:"0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe des Borders</div>
                        <input type="text" name="lightGallery[lg_thumbnail_border_color]" class="form-control "
                               value="{$pluginConfig->lightGallery->lg_thumbnail_border_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Aktive Farbe des Borders</div>
                        <input type="text" name="lightGallery[lg_thumbnail_active_border_color]" class="form-control cssColorPicker"
                               value="{$pluginConfig->lightGallery->lg_thumbnail_active_border_color|default:"#fbc0c0"}"
                               placeholder="{__('')}">
                    </div>
                </div>
            </div>
        </div>

<hr>
        <div class="input-group mb-3 css-strech">
            <div class="input-group-prepend">
                <span class="input-group-text"
                      style="width:200px; white-space:normal; text-align:left">{__('Darstellung der Pfeile')}</span>
            </div>
            <div class="input-group-append" style="flex:1 0 1%;">
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Farbe</div>
                        <input type="text" name="lightGallery[lg_arrow_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_arrow_color|default:"#000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Farbe</div>
                        <input type="text" name="lightGallery[lg_arrow_hover_color]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_arrow_hover_color|default:"#fb000"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[lg_arrow_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_arrow_bgcolor|default:"transparent"}"
                               placeholder="{__('')}">
                    </div>
                </div>
                <div class="input-group-append">
                    <div>
                        <div class="input-group-text css-blue">Hover Hintergrundfarbe</div>
                        <input type="text" name="lightGallery[lg_arrow_hover_bgcolor]" class="form-control"
                               value="{$pluginConfig->lightGallery->lg_arrow_hover_bgcolor|default:"transparent"}"
                               placeholder="{__('')}">
                    </div>
                </div>

            </div>
        </div>
    </fieldset>

        <fieldset class="border p-2 form-group">
        <legend class="w-auto" data-section="css_js">
            {__('Zusätzliche Styles/ JavaScript')}
            <span data-html="true" data-toggle="tooltip" data-placement="left" title=""
                  data-original-title="{__('Erklärung zur Nutzung des JS / CSS.')}">
                    <span class="fas fa-info-circle fa-fw"></span>
                </span>
        </legend>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('Styles')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror sass" id="css"
                          name="css">{$pluginConfig->css}</textarea>
            </div>
        </div>

        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text" style="width:200px; white-space:normal; text-align:left">{__('JavaScript')}</span>
            </div>
            <div class="input-group-append" style="flex: 1 0 60%;">
                <textarea style="min-height:60px;" class="form-control css-codemirror JavaScript" id="js"
                          name="js">{$pluginConfig->js}</textarea>
            </div>
        </div>

    </fieldset>


    <div class="save-wrapper">
        <div class="ml-auto col-sm-6 col-xl-auto">
            <button name="a" type="submit" value="" class="btn btn-outline-primary btn-block save">
                <i class="fas fa-save"></i>&nbsp;{__('Konfiguration speichern')}
            </button>
        </div>
    </div>
</form>

<script>
  $(function () {
    $(document).on("change", "#pluginActive", function () {
      $(this).removeClass("pluginActive-Y pluginActive-N").addClass("pluginActive-" + $(this).val()).blur();
    });
    $("#pluginActive").trigger("change");

    $("[name*='color']").spectrum({
      showInput: true,
      allowEmpty: false,
      showAlpha: true,
      showInput: true,
      showInitial: true,
      clickoutFiresChange: false,
      chooseText: "Farbe übernehmen",
      theme: "sp-dark",
      preferredFormat: 'rgb',
    });
  });
</script>
