<?php declare(strict_types=1);

namespace Plugin\css_gallery\Migrations;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20250907123302
 * @package Plugin\jtl_test\Migrations
 */
class Migration20250907123302 extends Migration implements IMigration {
	/**
	 * @inheritdoc
	 */

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj = $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if ($obj && (int)$obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1", 1);
			$obj->Rows = (int)$o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function up() {
		$cfg = $this->getDB()->query("select * from css_galleryConfig where 1", 1);

		$oldCfg = json_decode($cfg->lightGallery);

		$newCfg = json_decode("{\"thumbnail_border_style\":\"solid\",\"thumbnail_border_width\":\"2px\",\"thumbnail_border_radius\":\"10px 10px 10px 10px\",\"thumbnail_border_color\":\"rgb(212, 210, 201)\",\"thumbnail_active_border_color\":\"rgb(0, 0, 0)\",\"thumbnail_arrow_color\":\"rgb(109, 103, 103)\",\"thumbnail_arrow_hover_color\":\"#000\",\"thumbnail_arrow_bgcolor\":\"rgba(255, 255, 255, 0)\",\"thumbnail_arrow_hover_bgcolor\":\"rgba(232, 21, 21, 0)\",\"gallery_arrow_color\":\"#000\",\"gallery_arrow_hover_color\":\"rgb(255, 255, 255)\",\"gallery_arrow_bgcolor\":\"#d1d1d1\",\"gallery_arrow_hover_bgcolor\":\"rgb(169, 163, 163)\",\"gallery_caption_fontSize\":\"14px\",\"gallery_caption_fontStyle\":\"Y\",\"gallery_caption_color\":\"rgb(0, 0, 0)\",\"gallery_caption_bgcolor\":\"rgba(0, 0, 0, 0)\",\"lightGallery_download\":\"N\",\"lightGallery_zoom_function\":\"click\",\"lightGallery_rotate\":\"Y\",\"thumbail_position\":\"LB\",\"lightGallery_fullscreen\":\"Y\",\"lightGallery_mode\":\"lg-slide-circular\",\"lightGallery_zoom\":\"Y\",\"lightGallery_speed\":\"500\",\"lightGallery_share\":\"Y\",\"lightGallery_picture\":\"xl\",\"lg_background_color\":\"rgb(255, 255, 255)\",\"lg_color\":\"rgb(3, 3, 3)\",\"lg_toolbar_background_color\":\"rgba(0, 0, 0, 0.652)\",\"lg_toolbar_color\":\"rgb(249, 251, 248)\",\"lg_toolbar_hover_color\":\"rgb(59, 214, 81)\",\"lg_thumbnail_border_style\":\"solid\",\"lg_thumbnail_border_width\":\"2px\",\"lg_thumbnail_border_radius\":\"10px\",\"lg_thumbnail_border_color\":\"rgb(155, 158, 154)\",\"lg_thumbnail_active_border_color\":\"rgb(0, 0, 0)\",\"lg_arrow_color\":\"rgb(129, 125, 125)\",\"lg_arrow_hover_color\":\"rgb(255, 255, 255)\",\"lg_arrow_bgcolor\":\"rgba(165, 158, 158, 0.646)\",\"lg_arrow_hover_bgcolor\":\"rgba(98, 99, 102, 0.837)\"}");

		foreach ($newCfg as $k => $v) {
			if (empty($oldCfg->{$k})) {
				$oldCfg->{$k} = $v;
			}
		}

		$this->getDB()->query("update css_galleryConfig set lightGallery = '" . json_encode($oldCfg) . "' where 1", 3);

	}

	/**
	 * @inheritdoc
	 */
	public function down() {
	}
}
