<?php declare(strict_types=1);

namespace Plugin\css_gallery\Migrations;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20210429123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20210429123301 extends Migration implements IMigration {
	/**
	 * @inheritdoc
	 */


	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj = $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if ($obj && (int)$obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1", 1);
			$obj->Rows = (int)$o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function up() {
		$this->execute("
              CREATE TABLE IF NOT EXISTS `css_galleryConfig` (
                  `version` varchar(10) NOT NULL DEFAULT '1.0.0',
                  `sqlupdate` int(10) NOT NULL DEFAULT '0',
                  `pluginActive` char(1) NOT NULL default 'N',
                  `framework` char(20) NOT NULL default 'B4',
                  `css` text NOT NULL,
                  `js` text NOT NULL,
                  `lightGallery` text NOT NULL,
                  `selector_gallery` varchar(255) NOT NULL DEFAULT '#content',
                  `selector_gallery_position` varchar(15) NOT NULL DEFAULT 'after',
                  `selector_thumbnails` varchar(255) NOT NULL DEFAULT '#content',
                  `selector_thumbnails_position` varchar(15) NOT NULL DEFAULT 'after'
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");


		if (($obj = $this->tableExist('css_galleryConfig')) && $obj->Rows > 0) {
			$this->execute("UPDATE css_galleryConfig set `version` = '1.0.0' ");
		} else {
			$this->execute("
			INSERT INTO `css_galleryConfig` (`version`, `sqlupdate`, `pluginActive`, `framework`, `css`, `js`, `lightGallery`, `selector_gallery`, `selector_gallery_position`, `selector_thumbnails`, `selector_thumbnails_position`) VALUES
('1.0.0', 0, 'Y', 'B4', '', '', '{\"thumbnail_border_style\":\"solid\",\"thumbnail_border_color\":\"#000\",\"thumbnail_active_border_color\":\"#fb0000\",\"thumbnail_border_width\":\"2px\",\"thumbnail_border_radius\":\"10px 10px 10px 10px\",\"thumbnail_arrow_color\":\"#d1d1d1\",\"thumbnail_arrow_hover_color\":\"#000\",\"thumbnail_arrow_bgcolor\":\"transparent\",\"thumbnail_arrow_hover_bgcolor\":\"transparent\",\"thumbnail_arrow_opacity\":\"1\",\"gallery_arrow_color\":\"#000\",\"gallery_arrow_hover_color\":\"#fff\",\"gallery_arrow_bgcolor\":\"#d1d1d1\",\"gallery_arrow_hover_bgcolor\":\"#a1a1a1\",\"gallery_arrow_opacity\":\"0.6\",\"lightGallery_mode\":\"lg-lollipop-rev\",\"lightGallery_speed\":\"500\",\"lightGallery_picture\":\"lg\",\"lightGallery_download\":\"N\",\"lightGallery_rotate\":\"Y\",\"lightGallery_fullscreen\":\"Y\",\"lightGallery_zoom\":\"Y\",\"lightGallery_share\":\"Y\"}', '#gallery_wrapper', 'html', '.product-detail-image-preview-bar', 'html');

			"
			);


		}

	}

	/**
	 * @inheritdoc
	 */
	public function down() {
	}
}
