<?php declare(strict_types=1);

namespace Plugin\css_digiBon\Migrations;
use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20210515123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20210515123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */




    public function columnExists($table, $column) {
        $result = $this->getDB()->query("SHOW COLUMNS FROM $table like '$column'", 1);
        if($result !== null && $result !== false) return true;
        return false;
    }


    public function up()    {
        if(self::columnExists('css_digiBonConfig','sendBonDATEV') === false ) {
            $this->execute(
                "ALTER TABLE `css_digiBonConfig` ADD `sendBonDATEV` VARCHAR(1) NOT NULL DEFAULT 'N' "
            );
        }
        if(self::columnExists('css_digiBonConfig','DATEVeMail') === false ) {
            $this->execute(
                "ALTER TABLE `css_digiBonConfig` ADD `DATEVeMail` VARCHAR(250) NOT NULL DEFAULT ''  "
            );
        }
        $this->execute(
            "UPDATE `css_digiBonConfig` SET `version` = '2.1.0'  "
        );

    }

    public function down() {
    }
}
