<?php declare(strict_types=1);

namespace Plugin\css_digiBon\Migrations;

use JTL\Helpers\Text;
use JTL\Plugin\PluginInterface;
use JTL\Shop;
use JTL\Mail\Mail\Mail;
use JTL\Mail\Mailer;


use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20210429123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20210429123301 extends Migration implements IMigration   {
    /**
     * @inheritdoc
     */

    public function copyTable($sourceDB,$destinationDB="", $copyTable=true,$deleteSourceDB=false) {
        error_log('starte copy '.$sourceDB);
        $result = $this->getDB()->query("SHOW TABLES LIKE '".$sourceDB."'",2);
        if($copyTable && $result !== null && is_array($result) && count($result)) {
            error_log('DB Vorhanden '.$sourceDB);
            $result = $this->getDB()->query("SELECT * FROM ".$sourceDB." WHERE 1",2);
            foreach($result as $oItem) {
                error_log('schreibe Datensatz nach '.$destinationDB);
                $this->getDB()->insert($destinationDB,$oItem);
            }
        }
        if($deleteSourceDB) {
            $this->execute("DROP TABLE IF EXISTS ".$sourceDB,3);
        }
    }




    public function up()    {
        $this->execute("
              CREATE TABLE IF NOT EXISTS `css_digiBonConfig` (
                  `version` varchar(255) NOT NULL DEFAULT '2.0.0',
                  `sqlupdate` int(10) NOT NULL DEFAULT '0',
                  `pluginActive` char(1) NOT NULL default 'N',
                  `framework` char(3) NOT NULL default 'B4',
                  `storageDays` int(10) NOT NULL DEFAULT '3',
                  `TOKEN` varchar(255) NOT NULL DEFAULT '0',
                  `access` varchar(255) NOT NULL DEFAULT '0',
                  `extensions` varchar(255) NOT NULL DEFAULT 'jpg,jpeg,gif,png,webp,bmp,pdf',
                  `KASSENID` text NOT NULL,
                  `maxToShow` int(4) NOT NULL DEFAULT '3',
                  `seo` varchar(255) NOT NULL DEFAULT 'DigiBon',
                  `sendBon` char(1) NOT NULL DEFAULT 'Y'
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");

        $this->execute("
              CREATE TABLE IF NOT EXISTS `css_digiBonData` (
                  `id` int(10) NOT NULL AUTO_INCREMENT,
                  `digiBon` mediumblob NOT NULL,
                  `tstamp` int(11) NOT NULL DEFAULT '0',
                  `bon` varchar(255) NOT NULL DEFAULT '',
                  `hash` varchar(255) NOT NULL DEFAULT '',
                  `KASSENID` varchar(255) NOT NULL DEFAULT '',
                  `extension` varchar(4) NOT NULL DEFAULT '',
                  `counter` int(4) NOT NULL DEFAULT '0',
                  `seo` varchar(255) NOT NULL DEFAULT '',
                  PRIMARY KEY (`id`)
                ) ENGINE=InnoDB COLLATE utf8_unicode_ci
        ");


        $this->copyTable("css_digiBon_konfig","css_digiBonConfig",true,true);
        $this->copyTable("css_digiBon_data","css_digiBonData",true,true);


        $result = $this->getDB()->query(
            'SELECT * from `css_digiBonConfig` where 1',
            2
        );

        if($result === null || count($result) < 1) {
           $this->execute(
            "INSERT INTO `css_digiBonConfig` (`maxToShow`) VALUES ('3')"
            );
        } else {
            $this->execute("UPDATE css_digiBonConfig set `version` = '2.0.0' ");
        }
    }

    /**
     * @inheritdoc
     */
    public function down() {
        if ($this->doDeleteData()) {
        }
    }
}
