<?php declare(strict_types=1);
/**
 * @copyright (c) JTL-Software-GmbH
 * @license       http://jtl-url.de/jtlshoplicense
 */

namespace Plugin\css_CustomerLogin\Migrations;

use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20211109123301
 */
class Migration20250716123301 extends Migration implements IMigration
{
    /**
     * @inheritdoc
     */

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}


	public function up() {

		if(!$this->columnExist("css_CustomerLoginConfig", "version"))
			$this->execute(
				"
								ALTER TABLE `css_CustomerLoginConfig` CHANGE `version` `version` VARCHAR(10) NOT NULL DEFAULT '2.0.0';
			");

		if(!$this->columnExist("css_CustomerLoginConfig", "selector_checkout_account"))
			$this->execute(
				"
								ALTER TABLE `css_CustomerLoginConfig` ADD `selector_checkout_account` VARCHAR(255) NOT NULL DEFAULT '#create_account_data' ;
			");

		if(!$this->columnExist("css_CustomerLoginConfig", "selector_position_checkout_account"))
			$this->execute(
				"
								ALTER TABLE `css_CustomerLoginConfig` ADD `selector_position_checkout_account` VARCHAR(10) NOT NULL DEFAULT 'append' ;
			");

		if(!$this->columnExist("css_CustomerLoginConfig", "useEye"))
	    $this->execute(
		    "
								ALTER TABLE `css_CustomerLoginConfig` ADD `useEye` CHAR(1) NOT NULL DEFAULT 'Y' ;
			");

		if(!$this->columnExist("css_CustomerLoginConfig", "css"))
			$this->execute(
				"
								ALTER TABLE `css_CustomerLoginConfig` ADD `css` TEXT NOT NULL
			");

		if(!$this->columnExist("css_CustomerLoginConfig", "js"))
			$this->execute(
				"
								ALTER TABLE `css_CustomerLoginConfig` ADD `js` TEXT NOT NULL
			");


	}

    /**
     * @inheritdoc
     */
    public function down()    {
		}
}
