<?php declare(strict_types=1);
/**
 * @copyright (c) JTL-Software-GmbH
 * @license       http://jtl-url.de/jtlshoplicense
 */

namespace Plugin\css_CustomerLogin\Migrations;

use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20211109123301
 */
class Migration20211109123301 extends Migration implements IMigration
{
    /**
     * @inheritdoc
     */

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}

  public function up() {
    if (($obj = $this->tableExist('css_CustomerLoginConfig')) && $obj->Rows > 0) {
	    $this->execute("UPDATE css_CustomerLoginConfig set `version` = '2.0.1' ");
    } else {
	    $this->execute(
		    "INSERT INTO `css_CustomerLoginConfig` (`version`) VALUES ('2.0.1')"
	    );
    }
  }

    /**
     * @inheritdoc
     */
  public function down()    {
#	    $this->execute("UPDATE css_CustomerLoginConfig set `version` = '2.0.0' ");
  }
}
