<?php declare(strict_types=1);
/**
 * @copyright (c) JTL-Software-GmbH
 * @license       http://jtl-url.de/jtlshoplicense
 */

namespace Plugin\css_CustomerLogin\Migrations;

use JTL\Plugin\Migration;
use JTL\Update\IMigration;

/**
 * Class Migration20200910123301
 * @package Plugin\jtl_test\Migrations
 */
class Migration20180910123301 extends Migration implements IMigration {
    /**
     * @inheritdoc
     */

	public function columnExist($table, $field) {
		// false bedeutet das es die Spalte nicht gibt
		return $this->getDB()->query("Show columns from `" . $table . "` like '" . $field . "' ", 1);
	}

	public function tableExist($table) {
		// in Rows steht die Anzahl der Zeilen, false bedeutet das es die Tabelle nicht gibt
		$obj =  $this->getDB()->query("SHOW TABLE STATUS  like '" . $table . "'", 1);
		if($obj && (int) $obj->Rows == 0) {
			$o = $this->getDB()->query("SELECT COUNT(*) AS anzahl FROM " . $table . " WHERE 1",1);
			$obj->Rows = (int) $o->anzahl;
			return $obj;
		}
		return $obj;
	}

  public function up() {
    $this->execute(
      'CREATE TABLE IF NOT EXISTS `css_CustomerLoginConfig` (
            `version` varchar(250) NOT NULL default "2.0.0",
            `cookieName` varchar(250) NOT NULL default "css_CustomerLogin",
            `cookieTime` int(10) NOT NULL default "365",
            `checkboxActive` char(1) NOT NULL default "Y",
            `pluginActive` char(1) NOT NULL default "N",
            `welcomeMsg` char(1) NOT NULL default "M",
            `framework` char(3) NOT NULL default "B4",
					  `selector_welcome` varchar(250) NOT NULL DEFAULT "body",
					  `selector_position_welcome` varchar(10) NOT NULL DEFAULT "append",
					  `selector_login` varchar(250) NOT NULL DEFAULT ".login-form-submit",
					  `selector_position_login` varchar(10) NOT NULL DEFAULT "before",
					  `selector_checkout` varchar(250) NOT NULL DEFAULT ".customer-login-buttons",
					  `selector_position_checkout` varchar(10) NOT NULL DEFAULT "before",
					  `selector_header` varchar(250) NOT NULL DEFAULT "#quick-login  .account-icon-dropdown-pass",
					  `selector_position_header` varchar(10) NOT NULL DEFAULT "after",
					  `selector_register` varchar(250) NOT NULL DEFAULT ".checkout-button-row-submit",
					  `selector_position_register` varchar(10) NOT NULL DEFAULT "after",
					  `selector_checkout_account` varchar(255) NOT NULL DEFAULT "#create_account_data",
					  `selector_position_checkout_account` varchar(10) NOT NULL DEFAULT "append"
      ) ENGINE=InnoDB COLLATE utf8_unicode_ci'
	  );

    $this->execute(
        'CREATE TABLE IF NOT EXISTS `css_CustomerLogin` (
              `kKunde` int(10) NOT NULL default "0",
              `cHash` varchar(250) NOT NULL default "",
              `tstamp` int(10) NOT NULL default "0"
        ) ENGINE=InnoDB COLLATE utf8_unicode_ci'
    );

	  if (($obj = $this->tableExist('css_CustomerLoginConfig')) && $obj->Rows > 0) {
		  $this->execute("UPDATE css_CustomerLoginConfig set `version` = '2.0.0' ");
	  } else {
		  $this->execute(
			  "INSERT INTO `css_CustomerLoginConfig` (`version`) VALUES ('2.0.0')"
		  );
	  }

  }

    /**
     * @inheritdoc
     */
    public function down()    {
    }
}
